/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.SecurityProxy;

public class Main {
    protected static ToolErrorReporter errorReporter;
    protected static Global global;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static boolean sealedStdLib;
    static Vector fileList;
    private static SecurityProxy securityImpl;

    public static void main(String[] args) {
        try {
            if (Boolean.getBoolean("rhino.use_java_policy_security")) {
                Main.initJavaPolicySecuritySupport();
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace(System.err);
        }
        int result = Main.exec(args);
        if (result != 0) {
            System.exit(result);
        }
    }

    public static int exec(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-sealedlib")) continue;
            sealedStdLib = true;
            break;
        }
        Context cx = Main.enterContext();
        global = Main.getGlobal();
        errorReporter = new ToolErrorReporter(false, global.getErr());
        cx.setErrorReporter(errorReporter);
        args = Main.processOptions(cx, args);
        if (processStdin) {
            fileList.addElement(null);
        }
        Object[] array = new Object[args.length];
        System.arraycopy(args, 0, array, 0, args.length);
        Scriptable argsObj = cx.newArray((Scriptable)global, array);
        global.defineProperty("arguments", argsObj, 2);
        for (int i = 0; i < fileList.size(); ++i) {
            Main.processSource(cx, (String)fileList.elementAt(i));
        }
        cx.exit();
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Global getGlobal() {
        if (global == null) {
            try {
                global = new Global(Main.enterContext());
            }
            finally {
                Context.exit();
            }
        }
        return global;
    }

    static Context enterContext() {
        Context cx = new Context();
        if (securityImpl != null) {
            cx.setSecurityController(securityImpl);
        }
        return Context.enter(cx);
    }

    public static String[] processOptions(Context cx, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            double d;
            String arg = args[i];
            if (!arg.startsWith("-")) {
                processStdin = false;
                fileList.addElement(arg);
                String[] result = new String[args.length - i - 1];
                System.arraycopy(args, i + 1, result, 0, args.length - i - 1);
                return result;
            }
            if (arg.equals("-version")) {
                if (++i == args.length) {
                    Main.usage(arg);
                }
                if ((d = Context.toNumber(args[i])) != d) {
                    Main.usage(arg);
                }
                cx.setLanguageVersion((int)d);
                continue;
            }
            if (arg.equals("-opt") || arg.equals("-O")) {
                if (++i == args.length) {
                    Main.usage(arg);
                }
                if ((d = Context.toNumber(args[i])) != d) {
                    Main.usage(arg);
                }
                cx.setOptimizationLevel((int)d);
                continue;
            }
            if (arg.equals("-e")) {
                processStdin = false;
                if (++i == args.length) {
                    Main.usage(arg);
                }
                Main.evaluateScript(cx, global, null, args[i], "<command>", 1, null);
                continue;
            }
            if (arg.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
                continue;
            }
            if (arg.equals("-f")) {
                processStdin = false;
                if (++i == args.length) {
                    Main.usage(arg);
                }
                fileList.addElement(args[i].equals("-") ? null : args[i]);
                continue;
            }
            if (arg.equals("-sealedlib")) {
                if (sealedStdLib) continue;
                Kit.codeBug();
                continue;
            }
            Main.usage(arg);
        }
        return new String[0];
    }

    public static void usage(String s) {
        Main.p(ToolErrorReporter.getMessage("msg.shell.usage", s));
        System.exit(1);
    }

    private static void initJavaPolicySecuritySupport() {
        Throwable exObj;
        try {
            Class<?> cl = Class.forName("org.mozilla.javascript.tools.shell.JavaPolicySecurity");
            securityImpl = (SecurityProxy)cl.newInstance();
            return;
        }
        catch (ClassNotFoundException ex) {
            exObj = ex;
        }
        catch (IllegalAccessException ex) {
            exObj = ex;
        }
        catch (InstantiationException ex) {
            exObj = ex;
        }
        catch (LinkageError ex) {
            exObj = ex;
        }
        throw new RuntimeException("Can not load security support: " + exObj);
    }

    public static void processSource(Context cx, String filename) {
        if (filename == null || filename.equals("-")) {
            if (filename == null) {
                Main.getOut().println(cx.getImplementationVersion());
            }
            cx.setOptimizationLevel(-1);
            BufferedReader in = new BufferedReader(new InputStreamReader(global.getIn()));
            int lineno = 1;
            boolean hitEOF = false;
            while (!hitEOF) {
                int startline = lineno;
                if (filename == null) {
                    global.getErr().print("js> ");
                }
                global.getErr().flush();
                String source = "";
                do {
                    String newline;
                    try {
                        newline = in.readLine();
                    }
                    catch (IOException ioe) {
                        global.getErr().println(ioe.toString());
                        break;
                    }
                    if (newline == null) {
                        hitEOF = true;
                        break;
                    }
                    source = source + newline + "\n";
                    ++lineno;
                } while (!cx.stringIsCompilableUnit(source));
                Object result = Main.evaluateScript(cx, global, null, source, "<stdin>", startline, null);
                if (result != cx.getUndefinedValue()) {
                    try {
                        global.getErr().println(Context.toString(result));
                    }
                    catch (EcmaError ee) {
                        String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ee.toString());
                        exitCode = 3;
                        if (ee.getSourceName() != null) {
                            Context.reportError(msg, ee.getSourceName(), ee.getLineNumber(), ee.getLineSource(), ee.getColumnNumber());
                        }
                        Context.reportError(msg);
                    }
                }
                NativeArray h = Main.global.history;
                h.put((int)h.getLength(), (Scriptable)h, (Object)source);
            }
            global.getErr().println();
        } else {
            Main.processFile(cx, global, filename);
        }
        System.gc();
    }

    public static void processFile(Context cx, Scriptable scope, String filename) {
        if (securityImpl == null) {
            Main.processFileSecure(cx, scope, filename, null);
        } else {
            securityImpl.callProcessFileSecure(cx, scope, filename);
        }
    }

    static void processFileSecure(Context cx, Scriptable scope, String filename, Object securityDomain) {
        Reader in = null;
        try {
            URL url = new URL(filename);
            InputStream is = url.openStream();
            in = new BufferedReader(new InputStreamReader(is));
        }
        catch (MalformedURLException mfex) {
            in = null;
        }
        catch (IOException ioex) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open.url", filename, ioex.toString()));
            exitCode = 4;
            return;
        }
        if (in == null) {
            try {
                in = new PushbackReader(new FileReader(filename));
                int c = in.read();
                if (c == 35) {
                    while ((c = in.read()) != -1 && c != 10 && c != 13) {
                    }
                    ((PushbackReader)in).unread(c);
                } else {
                    in.close();
                    in = new FileReader(filename);
                }
                filename = new File(filename).getCanonicalPath();
            }
            catch (FileNotFoundException ex) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", filename));
                exitCode = 4;
                return;
            }
            catch (IOException ioe) {
                global.getErr().println(ioe.toString());
            }
        }
        Main.evaluateScript(cx, scope, in, null, filename, 1, securityDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateScript(Context cx, Scriptable scope, Reader in, String script, String sourceName, int lineno, Object securityDomain) {
        Object result;
        block14: {
            result = cx.getUndefinedValue();
            try {
                if (in != null) {
                    try {
                        try {
                            result = cx.evaluateReader(scope, in, sourceName, lineno, securityDomain);
                            break block14;
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (IOException ioe) {
                        global.getErr().println(ioe.toString());
                    }
                    break block14;
                }
                result = cx.evaluateString(scope, script, sourceName, lineno, securityDomain);
            }
            catch (WrappedException we) {
                global.getErr().println(we.getWrappedException().toString());
                we.printStackTrace();
            }
            catch (EcmaError ee) {
                String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ee.toString());
                exitCode = 3;
                if (ee.getSourceName() != null) {
                    Context.reportError(msg, ee.getSourceName(), ee.getLineNumber(), ee.getLineSource(), ee.getColumnNumber());
                } else {
                    Context.reportError(msg);
                }
            }
            catch (VirtualMachineError ex) {
                ex.printStackTrace();
                String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ex.toString());
                exitCode = 3;
                Context.reportError(msg);
            }
            catch (EvaluatorException ee) {
                exitCode = 3;
            }
            catch (JavaScriptException jse) {
                exitCode = 3;
                Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", jse.getMessage()));
            }
        }
        return result;
    }

    private static void p(String s) {
        global.getOut().println(s);
    }

    public static ScriptableObject getScope() {
        return global;
    }

    public static InputStream getIn() {
        return Global.getInstance(Main.getGlobal()).getIn();
    }

    public static void setIn(InputStream in) {
        Global.getInstance(Main.getGlobal()).setIn(in);
    }

    public static PrintStream getOut() {
        return Global.getInstance(Main.getGlobal()).getOut();
    }

    public static void setOut(PrintStream out) {
        Global.getInstance(Main.getGlobal()).setOut(out);
    }

    public static PrintStream getErr() {
        return Global.getInstance(Main.getGlobal()).getErr();
    }

    public static void setErr(PrintStream err) {
        Global.getInstance(Main.getGlobal()).setErr(err);
    }

    static {
        exitCode = 0;
        processStdin = true;
        sealedStdLib = false;
        fileList = new Vector(5);
    }
}

