/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class CounterResetResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BoxStyleKeys.DISPLAY_ROLE};
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.NONE.equals(cSSValue)) {
            return;
        }
        CSSValue cSSValue2 = layoutContext.getValue(styleKey);
        if (!(cSSValue2 instanceof CSSValueList)) {
            return;
        }
        CSSValueList cSSValueList = (CSSValueList)cSSValue2;
        for (int i = 0; i < cSSValueList.getLength(); ++i) {
            CSSValuePair cSSValuePair;
            CSSValue cSSValue3;
            CSSValue cSSValue4 = cSSValueList.getItem(i);
            if (!(cSSValue4 instanceof CSSValuePair) || !((cSSValue3 = (cSSValuePair = (CSSValuePair)cSSValue4).getFirstValue()) instanceof CSSConstant)) continue;
            CSSValue cSSValue5 = cSSValuePair.getSecondValue();
            int n = this.parseCounterValue(cSSValue5, layoutElement);
            layoutElement.resetCounter(cSSValue3.getCSSText(), n);
        }
    }

    private int parseCounterValue(CSSValue cSSValue, LayoutElement layoutElement) {
        if (cSSValue instanceof CSSNumericValue) {
            CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
            return (int)cSSNumericValue.getValue();
        }
        if (cSSValue instanceof CSSAttrFunction) {
            CSSAttrFunction cSSAttrFunction = (CSSAttrFunction)cSSValue;
            String string = cSSAttrFunction.getName();
            String string2 = cSSAttrFunction.getNamespace();
            Object object = layoutElement.getLayoutContext().getAttributes().getAttribute(string2, string);
            if (object instanceof Number) {
                Number number = (Number)object;
                return number.intValue();
            }
        }
        return 0;
    }
}

