/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;

@FunctionalInterface
public interface DataSelectionListener {
    public void selectionChanged(SelectionChangeEvent var1);

    public static class SelectionToggleEvent
    extends AbstractSelectionEvent {
        private final Set<OsmPrimitive> current;
        private final Set<OsmPrimitive> remove;
        private final Set<OsmPrimitive> add;

        public SelectionToggleEvent(DataSet dataSet, Set<OsmPrimitive> set, Stream<OsmPrimitive> stream) {
            super(dataSet, set);
            LinkedHashSet<OsmPrimitive> linkedHashSet = new LinkedHashSet<OsmPrimitive>(set);
            LinkedHashSet linkedHashSet2 = new LinkedHashSet();
            LinkedHashSet linkedHashSet3 = new LinkedHashSet();
            stream.forEach(osmPrimitive -> {
                if (linkedHashSet.remove(osmPrimitive)) {
                    linkedHashSet2.add(osmPrimitive);
                } else {
                    linkedHashSet3.add(osmPrimitive);
                    linkedHashSet.add((OsmPrimitive)osmPrimitive);
                }
            });
            this.current = Collections.unmodifiableSet(linkedHashSet);
            this.remove = Collections.unmodifiableSet(linkedHashSet2);
            this.add = Collections.unmodifiableSet(linkedHashSet3);
        }

        @Override
        public Set<OsmPrimitive> getSelection() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<OsmPrimitive> getRemoved() {
            return Collections.unmodifiableSet(this.remove);
        }

        @Override
        public Set<OsmPrimitive> getAdded() {
            return Collections.unmodifiableSet(this.add);
        }
    }

    public static class SelectionRemoveEvent
    extends AbstractSelectionEvent {
        private final Set<OsmPrimitive> remove;
        private final Set<OsmPrimitive> current;

        public SelectionRemoveEvent(DataSet dataSet, Set<OsmPrimitive> set, Stream<OsmPrimitive> stream) {
            super(dataSet, set);
            this.remove = stream.filter(set::contains).collect(Collectors.toCollection(LinkedHashSet::new));
            if (this.remove.isEmpty()) {
                this.current = this.getOldSelection();
            } else {
                LinkedHashSet<OsmPrimitive> linkedHashSet = new LinkedHashSet<OsmPrimitive>(set);
                linkedHashSet.removeAll(this.remove);
                this.current = Collections.unmodifiableSet(linkedHashSet);
            }
        }

        @Override
        public Set<OsmPrimitive> getSelection() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<OsmPrimitive> getRemoved() {
            return Collections.unmodifiableSet(this.remove);
        }

        @Override
        public Set<OsmPrimitive> getAdded() {
            return Collections.emptySet();
        }
    }

    public static class SelectionAddEvent
    extends AbstractSelectionEvent {
        private final Set<OsmPrimitive> add;
        private final Set<OsmPrimitive> current;

        public SelectionAddEvent(DataSet dataSet, Set<OsmPrimitive> set, Stream<OsmPrimitive> stream) {
            super(dataSet, set);
            this.add = stream.filter(osmPrimitive -> !set.contains(osmPrimitive)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (this.add.isEmpty()) {
                this.current = this.getOldSelection();
            } else {
                this.current = new LinkedHashSet<OsmPrimitive>(set);
                this.current.addAll(this.add);
            }
        }

        @Override
        public Set<OsmPrimitive> getSelection() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<OsmPrimitive> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public Set<OsmPrimitive> getAdded() {
            return Collections.unmodifiableSet(this.add);
        }
    }

    public static class SelectionReplaceEvent
    extends AbstractSelectionEvent {
        private final Set<OsmPrimitive> current;
        private Set<OsmPrimitive> removed;
        private Set<OsmPrimitive> added;

        public SelectionReplaceEvent(DataSet dataSet, Set<OsmPrimitive> set, Stream<OsmPrimitive> stream) {
            super(dataSet, set);
            this.current = stream.collect(Collectors.toCollection(LinkedHashSet::new));
        }

        @Override
        public Set<OsmPrimitive> getSelection() {
            return this.current;
        }

        @Override
        public synchronized Set<OsmPrimitive> getRemoved() {
            if (this.removed == null) {
                this.removed = this.getOldSelection().stream().filter(osmPrimitive -> !this.current.contains(osmPrimitive)).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            return this.removed;
        }

        @Override
        public synchronized Set<OsmPrimitive> getAdded() {
            if (this.added == null) {
                this.added = this.current.stream().filter(osmPrimitive -> !this.getOldSelection().contains(osmPrimitive)).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            return this.added;
        }
    }

    public static abstract class AbstractSelectionEvent
    implements SelectionChangeEvent {
        private final DataSet source;
        private final Set<OsmPrimitive> old;

        public AbstractSelectionEvent(DataSet dataSet, Set<OsmPrimitive> set) {
            CheckParameterUtil.ensureParameterNotNull(dataSet, "source");
            CheckParameterUtil.ensureParameterNotNull(set, "old");
            this.source = dataSet;
            this.old = Collections.unmodifiableSet(set);
        }

        @Override
        public Set<OsmPrimitive> getOldSelection() {
            return this.old;
        }

        @Override
        public DataSet getSource() {
            return this.source;
        }
    }

    public static interface SelectionChangeEvent {
        public Set<OsmPrimitive> getOldSelection();

        public Set<OsmPrimitive> getSelection();

        public Set<OsmPrimitive> getRemoved();

        public Set<OsmPrimitive> getAdded();

        public DataSet getSource();

        default public boolean isNop() {
            return this.getAdded().isEmpty() && this.getRemoved().isEmpty();
        }
    }
}

