/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;

public class CombinePrimitiveResolver {
    private final TagConflictResolverModel modelTagConflictResolver;
    private final RelationMemberConflictResolverModel modelRelConflictResolver;

    public CombinePrimitiveResolver(TagConflictResolverModel tagConflictResolverModel, RelationMemberConflictResolverModel relationMemberConflictResolverModel) {
        this.modelTagConflictResolver = tagConflictResolverModel;
        this.modelRelConflictResolver = relationMemberConflictResolverModel;
    }

    public List<Command> buildResolutionCommands(OsmPrimitive osmPrimitive) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        TagCollection tagCollection = this.modelTagConflictResolver.getAllResolutions();
        if (!tagCollection.isEmpty()) {
            linkedList.addAll(this.buildTagChangeCommand(osmPrimitive, tagCollection));
        }
        for (String string : OsmPrimitive.getDiscardableKeys()) {
            if (osmPrimitive.get(string) == null) continue;
            linkedList.add(new ChangePropertyCommand(osmPrimitive, string, null));
        }
        if (this.modelRelConflictResolver.getNumDecisions() > 0) {
            linkedList.addAll(this.modelRelConflictResolver.buildResolutionCommands(osmPrimitive));
        }
        return linkedList;
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive osmPrimitive, TagCollection tagCollection) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (String string : tagCollection.getKeys()) {
            if (tagCollection.hasUniqueEmptyValue(string)) {
                if (osmPrimitive.get(string) == null) continue;
                linkedList.add(new ChangePropertyCommand(osmPrimitive, string, null));
                continue;
            }
            String string2 = tagCollection.getJoinedValues(string);
            if (string2.equals(osmPrimitive.get(string))) continue;
            linkedList.add(new ChangePropertyCommand(osmPrimitive, string, string2));
        }
        return linkedList;
    }
}

