/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.awt.AWTPermission;
import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.PropertyPermission;
import java.util.Set;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.NullJnlpFileException;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityDesc {
    public static final Object ALL_PERMISSIONS = "All";
    public static final Object SANDBOX_PERMISSIONS = "Sandbox";
    public static final Object J2EE_PERMISSIONS = "J2SE";
    private final RequestedPermissionLevel requestedPermissionLevel;
    private Object type;
    private final URL downloadHost;
    private final boolean grantAwtPermissions;
    private final JNLPFile file;
    private final Policy customTrustedPolicy;
    private static Class<Permission> urlPermissionClass = null;
    private static Constructor<Permission> urlPermissionConstructor = null;
    private static Permission[] j2eePermissions;
    private static Permission[] sandboxPermissions;
    private static Permission[] jnlpRIAPermissions;

    public SecurityDesc(JNLPFile file, RequestedPermissionLevel requestedPermissionLevel, Object type, URL downloadHost) {
        if (file == null) {
            throw new NullJnlpFileException();
        }
        this.file = file;
        this.requestedPermissionLevel = requestedPermissionLevel;
        this.type = type;
        this.downloadHost = downloadHost;
        String key = "deployment.security.sandbox.awtwarningwindow";
        this.grantAwtPermissions = Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty(key));
        this.customTrustedPolicy = this.getCustomTrustedPolicy();
    }

    public SecurityDesc(JNLPFile file, Object type, URL downloadHost) {
        this(file, RequestedPermissionLevel.NONE, type, downloadHost);
    }

    private Policy getCustomTrustedPolicy() {
        String key = "deployment.security.trusted.policy";
        String policyLocation = JNLPRuntime.getConfiguration().getProperty(key);
        Policy policy = null;
        if (policyLocation != null) {
            try {
                URI policyUri = new URI("file://" + policyLocation);
                policy = Policy.getInstance("JavaPolicy", new URIParameter(policyUri));
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
        return policy;
    }

    public Object getSecurityType() {
        return this.type;
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this.getSandBoxPermissions();
        if (ALL_PERMISSIONS.equals(this.type)) {
            permissions = new Permissions();
            if (this.customTrustedPolicy == null) {
                permissions.add(new AllPermission());
                return permissions;
            }
            return this.customTrustedPolicy.getPermissions(cs);
        }
        if (J2EE_PERMISSIONS.equals(this.type)) {
            for (Permission j2eePermission : j2eePermissions) {
                permissions.add(j2eePermission);
            }
        }
        return permissions;
    }

    public RequestedPermissionLevel getRequestedPermissionLevel() {
        return this.requestedPermissionLevel;
    }

    public PermissionCollection getSandBoxPermissions() {
        Permissions permissions = new Permissions();
        for (Permission sandboxPermission : sandboxPermissions) {
            permissions.add(sandboxPermission);
        }
        if (this.grantAwtPermissions) {
            permissions.add(new AWTPermission("showWindowWithoutWarningBanner"));
        }
        if (JNLPRuntime.isWebstartApplication()) {
            if (this.file == null) {
                throw new NullJnlpFileException("Can not return sandbox permissions, file is null");
            }
            if (this.file.isApplication()) {
                for (Permission jnlpRIAPermission : jnlpRIAPermissions) {
                    permissions.add(jnlpRIAPermission);
                }
            }
        }
        if (this.downloadHost != null && this.downloadHost.getHost().length() > 0) {
            permissions.add(new SocketPermission(UrlUtils.getHostAndPort(this.downloadHost), "connect, accept"));
        }
        Set<Permission> urlPermissions = this.getUrlPermissions();
        for (Permission permission : urlPermissions) {
            permissions.add(permission);
        }
        return permissions;
    }

    private Set<Permission> getUrlPermissions() {
        if (urlPermissionClass == null || urlPermissionConstructor == null) {
            return Collections.emptySet();
        }
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (JARDesc jar : this.file.getResources().getJARs()) {
            try {
                URI resourceLocation = jar.getLocation().toURI().normalize();
                URI host = SecurityDesc.getHost(resourceLocation);
                String hostUriString = host.toString();
                String urlPermissionUrlString = SecurityDesc.appendRecursiveSubdirToCodebaseHostString(hostUriString);
                Permission p = urlPermissionConstructor.newInstance(urlPermissionUrlString);
                permissions.add(p);
            }
            catch (ReflectiveOperationException e) {
                OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Exception while attempting to reflectively generate a URLPermission, probably not running on Java 8+?");
                OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, e);
            }
            catch (URISyntaxException e) {
                OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Could not determine codebase host for resource at " + jar.getLocation() + " while generating URLPermissions");
                OutputController.getLogger().log(e);
            }
        }
        try {
            URI codebase = this.file.getNotNullProbalbeCodeBase().toURI().normalize();
            URI host = SecurityDesc.getHost(codebase);
            String codebaseHostUriString = host.toString();
            String urlPermissionUrlString = SecurityDesc.appendRecursiveSubdirToCodebaseHostString(codebaseHostUriString);
            Permission p = urlPermissionConstructor.newInstance(urlPermissionUrlString);
            permissions.add(p);
        }
        catch (ReflectiveOperationException e) {
            OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Exception while attempting to reflectively generate a URLPermission, probably not running on Java 8+?");
            OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, e);
        }
        catch (URISyntaxException e) {
            OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Could not determine codebase host for codebase " + this.file.getCodeBase() + "  while generating URLPermissions");
            OutputController.getLogger().log(e);
        }
        return permissions;
    }

    static URI getHostWithSpecifiedPort(URI codebase, int port) throws URISyntaxException {
        Objects.requireNonNull(codebase);
        return new URI(codebase.getScheme(), codebase.getUserInfo(), codebase.getHost(), port, null, null, null);
    }

    static URI getHost(URI codebase) throws URISyntaxException {
        Objects.requireNonNull(codebase);
        return SecurityDesc.getHostWithSpecifiedPort(codebase, codebase.getPort());
    }

    static String appendRecursiveSubdirToCodebaseHostString(String codebaseHost) {
        Objects.requireNonNull(codebaseHost);
        String result = codebaseHost;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        result = result + "/-";
        return result;
    }

    public static String[] getJnlpRIAPermissions() {
        String[] jnlpPermissions = new String[jnlpRIAPermissions.length];
        for (int i = 0; i < jnlpRIAPermissions.length; ++i) {
            jnlpPermissions[i] = jnlpRIAPermissions[i].getName();
        }
        return jnlpPermissions;
    }

    static {
        try {
            urlPermissionClass = Class.forName("java.net.URLPermission");
            urlPermissionConstructor = urlPermissionClass.getDeclaredConstructor(String.class);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, "Exception while reflectively finding URLPermission - host is probably not running Java 8+");
            OutputController.getLogger().log(OutputController.Level.WARNING_DEBUG, e);
            urlPermissionClass = null;
            urlPermissionConstructor = null;
        }
        j2eePermissions = new Permission[]{new AWTPermission("accessClipboard"), new RuntimePermission("exitVM"), new RuntimePermission("loadLibrary"), new RuntimePermission("queuePrintJob"), new SocketPermission("*", "connect"), new SocketPermission("localhost:1024-", "accept, listen"), new FilePermission("*", "read, write"), new PropertyPermission("*", "read")};
        sandboxPermissions = new Permission[]{new SocketPermission("localhost:1024-", "listen"), new PropertyPermission("java.util.Arrays.useLegacyMergeSort", "read,write"), new PropertyPermission("java.version", "read"), new PropertyPermission("java.vendor", "read"), new PropertyPermission("java.vendor.url", "read"), new PropertyPermission("java.class.version", "read"), new PropertyPermission("os.name", "read"), new PropertyPermission("os.version", "read"), new PropertyPermission("os.arch", "read"), new PropertyPermission("file.separator", "read"), new PropertyPermission("path.separator", "read"), new PropertyPermission("line.separator", "read"), new PropertyPermission("java.specification.version", "read"), new PropertyPermission("java.specification.vendor", "read"), new PropertyPermission("java.specification.name", "read"), new PropertyPermission("java.vm.specification.vendor", "read"), new PropertyPermission("java.vm.specification.name", "read"), new PropertyPermission("java.vm.version", "read"), new PropertyPermission("java.vm.vendor", "read"), new PropertyPermission("java.vm.name", "read"), new PropertyPermission("javawebstart.version", "read"), new PropertyPermission("javaplugin.*", "read"), new PropertyPermission("jnlp.*", "read,write"), new PropertyPermission("javaws.*", "read,write"), new PropertyPermission("browser", "read"), new PropertyPermission("browser.*", "read"), new RuntimePermission("exitVM"), new RuntimePermission("stopThread")};
        jnlpRIAPermissions = new Permission[]{new PropertyPermission("awt.useSystemAAFontSettings", "read,write"), new PropertyPermission("http.agent", "read,write"), new PropertyPermission("http.keepAlive", "read,write"), new PropertyPermission("java.awt.syncLWRequests", "read,write"), new PropertyPermission("java.awt.Window.locationByPlatform", "read,write"), new PropertyPermission("javaws.cfg.jauthenticator", "read,write"), new PropertyPermission("javax.swing.defaultlf", "read,write"), new PropertyPermission("sun.awt.noerasebackground", "read,write"), new PropertyPermission("sun.awt.erasebackgroundonresize", "read,write"), new PropertyPermission("sun.java2d.d3d", "read,write"), new PropertyPermission("sun.java2d.dpiaware", "read,write"), new PropertyPermission("sun.java2d.noddraw", "read,write"), new PropertyPermission("sun.java2d.opengl", "read,write"), new PropertyPermission("swing.boldMetal", "read,write"), new PropertyPermission("swing.metalTheme", "read,write"), new PropertyPermission("swing.noxp", "read,write"), new PropertyPermission("swing.useSystemFontSettings", "read,write")};
    }

    public static enum RequestedPermissionLevel {
        NONE(null, null),
        DEFAULT(null, "default"),
        SANDBOX(null, "sandbox"),
        J2EE("j2ee-application-client-permissions", null),
        ALL("all-permissions", "all-permissions");

        public static final String PERMISSIONS_NAME = "permissions";
        private final String jnlpString;
        private final String htmlString;

        private RequestedPermissionLevel(String jnlpString, String htmlString) {
            this.jnlpString = jnlpString;
            this.htmlString = htmlString;
        }

        public String toJnlpString() {
            return this.jnlpString;
        }

        public String toHtmlString() {
            return this.htmlString;
        }

        public RequestedPermissionLevel fromJnlpString(String jnlpString) {
            for (RequestedPermissionLevel level : RequestedPermissionLevel.values()) {
                if (level.jnlpString == null || !level.jnlpString.equals(jnlpString)) continue;
                return level;
            }
            return null;
        }

        public RequestedPermissionLevel fromHtmlString(String htmlString) {
            for (RequestedPermissionLevel level : RequestedPermissionLevel.values()) {
                if (level.htmlString == null || !level.htmlString.equals(htmlString)) continue;
                return level;
            }
            return null;
        }
    }
}

