/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum SpatialStrategy implements Writeable
{
    TERM("term"),
    RECURSIVE("recursive");

    private final String strategyName;

    private SpatialStrategy(String strategyName) {
        this.strategyName = strategyName;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public static SpatialStrategy readFromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= SpatialStrategy.values().length) {
            throw new IOException("Unknown SpatialStrategy ordinal [" + ordinal + "]");
        }
        return SpatialStrategy.values()[ordinal];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static SpatialStrategy fromString(String strategyName) {
        for (SpatialStrategy strategy : SpatialStrategy.values()) {
            if (!strategy.strategyName.equals(strategyName)) continue;
            return strategy;
        }
        return null;
    }
}

