/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.HashCode;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.caching.internal.tasks.BuildCacheKeyInputs;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputCachingBuildCacheKeyBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskOutputCachingBuildCacheKeyBuilder.class);
    public static final TaskOutputCachingBuildCacheKey NO_CACHE_KEY = new DefaultTaskOutputCachingBuildCacheKeyBuilder().build();
    private BuildCacheHasher hasher = new DefaultBuildCacheHasher();
    private String taskClass;
    private HashCode classLoaderHash;
    private List<HashCode> actionsClassLoaderHashes;
    private final ImmutableSortedMap.Builder<String, HashCode> inputHashes = ImmutableSortedMap.naturalOrder();
    private final ImmutableSortedSet.Builder<String> outputPropertyNames = ImmutableSortedSet.naturalOrder();

    public DefaultTaskOutputCachingBuildCacheKeyBuilder appendTaskClass(String taskClass) {
        this.taskClass = taskClass;
        this.hasher.putString(taskClass);
        DefaultTaskOutputCachingBuildCacheKeyBuilder.log("taskClass", taskClass);
        return this;
    }

    public DefaultTaskOutputCachingBuildCacheKeyBuilder appendClassloaderHash(@Nullable HashCode hashCode) {
        this.classLoaderHash = hashCode;
        if (hashCode != null) {
            this.hasher.putBytes(hashCode.asBytes());
        }
        DefaultTaskOutputCachingBuildCacheKeyBuilder.log("classLoaderHash", hashCode);
        return this;
    }

    public DefaultTaskOutputCachingBuildCacheKeyBuilder appendActionsClassloaderHashes(List<HashCode> actionsClassLoaderHashes) {
        this.actionsClassLoaderHashes = actionsClassLoaderHashes;
        for (HashCode hashCode : actionsClassLoaderHashes) {
            if (hashCode != null) {
                this.hasher.putBytes(hashCode.asBytes());
            }
            DefaultTaskOutputCachingBuildCacheKeyBuilder.log("actionsClassLoaderHash", hashCode);
        }
        return this;
    }

    public DefaultTaskOutputCachingBuildCacheKeyBuilder appendInputPropertyHash(String propertyName, HashCode hashCode) {
        this.hasher.putString(propertyName);
        this.hasher.putBytes(hashCode.asBytes());
        this.inputHashes.put((Object)propertyName, (Object)hashCode);
        LOGGER.debug("Appending inputPropertyHash for '{}' to build cache key: {}", (Object)propertyName, (Object)hashCode);
        return this;
    }

    public DefaultTaskOutputCachingBuildCacheKeyBuilder appendOutputPropertyName(String propertyName) {
        this.outputPropertyNames.add((Object)propertyName);
        this.hasher.putString(propertyName);
        DefaultTaskOutputCachingBuildCacheKeyBuilder.log("outputPropertyName", propertyName);
        return this;
    }

    private static void log(String name, Object value) {
        LOGGER.debug("Appending {} to build cache key: {}", (Object)name, value);
    }

    public TaskOutputCachingBuildCacheKey build() {
        BuildCacheKeyInputs inputs = new BuildCacheKeyInputs(this.taskClass, this.classLoaderHash, this.actionsClassLoaderHashes, (ImmutableSortedMap<String, HashCode>)this.inputHashes.build(), (ImmutableSortedSet<String>)this.outputPropertyNames.build());
        if (this.classLoaderHash == null || this.actionsClassLoaderHashes.contains(null)) {
            return new DefaultTaskOutputCachingBuildCacheKey(null, inputs);
        }
        return new DefaultTaskOutputCachingBuildCacheKey(this.hasher.hash(), inputs);
    }

    private static class DefaultTaskOutputCachingBuildCacheKey
    implements TaskOutputCachingBuildCacheKey {
        private final HashCode hashCode;
        private final BuildCacheKeyInputs inputs;

        private DefaultTaskOutputCachingBuildCacheKey(HashCode hashCode, BuildCacheKeyInputs inputs) {
            this.hashCode = hashCode;
            this.inputs = inputs;
        }

        public String getHashCode() {
            return ((HashCode)Preconditions.checkNotNull((Object)this.hashCode, (Object)"Cannot determine hash code for invalid build cache key")).toString();
        }

        public BuildCacheKeyInputs getInputs() {
            return this.inputs;
        }

        public boolean isValid() {
            return this.hashCode != null;
        }

        public String toString() {
            return String.valueOf(this.hashCode);
        }
    }
}

