/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import org.gradle.internal.progress.ProgressFormatter;

public class ProgressBar
implements ProgressFormatter {
    private final String progressBarPrefix;
    private int progressBarWidth;
    private final String progressBarSuffix;
    private char fillerChar;
    private int current;
    private final char incompleteChar;
    private int total;
    private String suffix;

    public ProgressBar(String progressBarPrefix, int progressBarWidth, String progressBarSuffix, char completeChar, char incompleteChar, String suffix, int total) {
        this.progressBarPrefix = progressBarPrefix;
        this.progressBarWidth = progressBarWidth;
        this.progressBarSuffix = progressBarSuffix;
        this.fillerChar = completeChar;
        this.incompleteChar = incompleteChar;
        this.total = total;
        this.suffix = suffix;
    }

    public String incrementAndGetProgress() {
        this.increment();
        return this.getProgress();
    }

    public void increment() {
        if (this.current == this.total) {
            throw new IllegalStateException("Cannot increment beyond the total of: " + this.total);
        }
        ++this.current;
    }

    public String getProgress() {
        int completedWidth = (int)((double)this.current * 1.0 / (double)this.total * (double)this.progressBarWidth);
        int remainingWidth = this.progressBarWidth - completedWidth;
        return this.progressBarPrefix + new String(new char[completedWidth]).replace('\u0000', this.fillerChar) + new String(new char[remainingWidth]).replace('\u0000', this.incompleteChar) + this.progressBarSuffix + " " + (int)((double)this.current * 100.0 / (double)this.total) + '%' + ' ' + this.suffix;
    }
}

