/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.progress.BuildOperationDetails;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.DownloadBuildOperationDescriptor;

public class BuildOperationExternalResource
implements ExternalResource {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ExternalResource delegate;

    public BuildOperationExternalResource(BuildOperationExecutor buildOperationExecutor, ExternalResource delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
    }

    public URI getURI() {
        return this.delegate.getURI();
    }

    public boolean isLocal() {
        return this.delegate.isLocal();
    }

    public void close() {
        this.delegate.close();
    }

    public ExternalResourceMetaData getMetaData() {
        return this.delegate.getMetaData();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public void writeTo(final File destination) throws ResourceException {
        this.buildOperationExecutor.run(this.createBuildOperationDetails(), (Action)new Action<BuildOperationContext>(){

            public void execute(BuildOperationContext buildOperationContext) {
                BuildOperationExternalResource.this.delegate.writeTo(destination);
            }
        });
    }

    public void writeTo(final OutputStream destination) throws ResourceException {
        this.buildOperationExecutor.run(this.createBuildOperationDetails(), (Action)new Action<BuildOperationContext>(){

            public void execute(BuildOperationContext buildOperationContext) {
                BuildOperationExternalResource.this.delegate.writeTo(destination);
            }
        });
    }

    public void withContent(final Action<? super InputStream> readAction) throws ResourceException {
        this.buildOperationExecutor.run(this.createBuildOperationDetails(), (Action)new Action<BuildOperationContext>(){

            public void execute(BuildOperationContext buildOperationContext) {
                BuildOperationExternalResource.this.delegate.withContent(readAction);
            }
        });
    }

    public <T> T withContent(final Transformer<? extends T, ? super InputStream> readAction) throws ResourceException {
        return (T)this.buildOperationExecutor.run(this.createBuildOperationDetails(), new Transformer<T, BuildOperationContext>(){

            public T transform(BuildOperationContext buildOperationContext) {
                return BuildOperationExternalResource.this.delegate.withContent(readAction);
            }
        });
    }

    public <T> T withContent(final ExternalResource.ContentAction<? extends T> readAction) throws ResourceException {
        return (T)this.buildOperationExecutor.run(this.createBuildOperationDetails(), new Transformer<T, BuildOperationContext>(){

            public T transform(BuildOperationContext buildOperationContext) {
                return BuildOperationExternalResource.this.delegate.withContent(readAction);
            }
        });
    }

    private BuildOperationDetails createBuildOperationDetails() {
        ExternalResourceMetaData metaData = this.getMetaData();
        DownloadBuildOperationDescriptor downloadBuildOperationDescriptor = new DownloadBuildOperationDescriptor(metaData.getLocation(), metaData.getContentLength(), metaData.getContentType());
        return BuildOperationDetails.displayName((String)("Download " + metaData.getLocation().toString())).operationDescriptor((Object)downloadBuildOperationDescriptor).build();
    }
}

