#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cipher-aes
version: 0.2.11
id: cipher-aes-0.2.11-6WBeZzAuarp4b4pmaENTJ5
key: cipher-aes-0.2.11-6WBeZzAuarp4b4pmaENTJ5
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: https://github.com/vincenthz/hs-cipher-aes
synopsis: Fast AES cipher implementation with advanced mode of operations
description:
    Fast AES cipher implementation with advanced mode of operations.
    .
    The modes of operations available are ECB (Electronic code book),
    CBC (Cipher block chaining), CTR (Counter), XTS (XEX with ciphertext stealing),
    GCM (Galois Counter Mode).
    .
    The AES implementation uses AES-NI when available (on x86 and x86-64 architecture),
    but fallback gracefully to a software C implementation.
    .
    The software implementation uses S-Boxes, which might suffer for cache timing issues.
    However do notes that most other known software implementations, including very popular
    one (openssl, gnutls) also uses similar implementation. If it matters for your
    case, you should make sure you have AES-NI available, or you'\''ll need to use a different
    implementation.
    .
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Crypto.Cipher.AES
abi: dc62a367b703c3713a6e4689238ab4fd
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/cipher-aes-0.2.11
library-dirs: /usr/lib/ghc-8.0.1/site-local/cipher-aes-0.2.11
data-dir: /usr/share/arm-linux-ghc-8.0.1/cipher-aes-0.2.11
hs-libraries: HScipher-aes-0.2.11-6WBeZzAuarp4b4pmaENTJ5
depends:
    base-4.9.0.0 byteable-0.1.1-15aIBCArSOBEnGxArzrDTM
    bytestring-0.10.8.1
    crypto-cipher-types-0.0.9-AfrbXuzMbdh1qMQIWJkaB4
    securemem-0.1.9-27iPpKEc5cx9pB9GAggjZj
haddock-interfaces: /usr/share/doc/haskell-cipher-aes/html/cipher-aes.haddock
haddock-html: /usr/share/doc/haskell-cipher-aes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
