/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.AwsCandidateHarvester;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.CustomStreamsSocket;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.proxy.ProxyThreadSSL;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpUtil;
import org.parosproxy.paros.security.MissingRootCertificateException;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.network.HttpRequestBody;

public class ProxyThread
implements Runnable {
    private static final String CONNECT_HTTP_200 = "HTTP/1.1 200 Connection established\r\n\r\n";
    private static Logger log = Logger.getLogger(ProxyThread.class);
    private static final String BAD_GATEWAY_RESPONSE_STATUS = "502 Bad Gateway";
    private static final String GATEWAY_TIMEOUT_RESPONSE_STATUS = "504 Gateway Timeout";
    protected ProxyServer parentServer = null;
    protected ProxyParam proxyParam = null;
    protected ConnectionParam connectionParam = null;
    protected Thread thread = null;
    protected Socket inSocket = null;
    protected Socket outSocket = null;
    protected HttpInputStream httpIn = null;
    protected HttpOutputStream httpOut = null;
    protected ProxyThread originProcess = this;
    private HttpSender httpSender = null;
    private Object semaphore = this;
    private boolean keepSocketOpen = false;
    private static Object semaphoreSingleton = new Object();
    private static int id = 1;
    private static Vector<Thread> proxyThreadList = new Vector();
    private static AwsCandidateHarvester awsCandidateHarvester;

    protected ProxyThread(ProxyServer proxyServer, Socket socket) {
        this(proxyServer, socket, null);
    }

    protected ProxyThread(ProxyServer proxyServer, Socket socket, HttpSender httpSender) {
        this.parentServer = proxyServer;
        this.proxyParam = this.parentServer.getProxyParam();
        this.connectionParam = this.parentServer.getConnectionParam();
        this.httpSender = httpSender;
        this.inSocket = socket;
        try {
            this.inSocket.setTcpNoDelay(true);
            this.inSocket.setSoTimeout(this.connectionParam.getTimeoutInSecs() * 1000);
        }
        catch (SocketException socketException) {
            log.warn((Object)socketException.getMessage(), (Throwable)socketException);
        }
        this.thread = new Thread((Runnable)this, "ZAP-ProxyThread-" + id++);
        this.thread.setDaemon(true);
        this.thread.setPriority(4);
    }

    public void start() {
        this.thread.start();
    }

    private void beginSSL(String string) throws IOException {
        try {
            this.inSocket = HttpSender.getSSLConnector().createTunnelServerSocket(string, this.inSocket);
        }
        catch (MissingRootCertificateException missingRootCertificateException) {
            throw new MissingRootCertificateException(missingRootCertificateException);
        }
        catch (Exception exception) {
            throw new IOException("Error while establishing SSL connection for '" + string + "'!", exception);
        }
        this.httpIn = new HttpInputStream(this.inSocket);
        this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
    }

    private static boolean isSslTlsHandshake(byte[] byArray) {
        if (byArray.length < 3) {
            throw new IllegalArgumentException("The parameter bytes must have at least 3 bytes.");
        }
        return byArray[0] == 22 && (byArray[1] >= 3 || byArray[1] == 0 && byArray[2] == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            proxyThreadList.add(this.thread);
            boolean bl = this instanceof ProxyThreadSSL;
            HttpRequestHeader httpRequestHeader = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inSocket.getInputStream(), 2048);
                this.inSocket = new CustomStreamsSocket(this.inSocket, bufferedInputStream, this.inSocket.getOutputStream());
                this.httpIn = new HttpInputStream(this.inSocket);
                this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
                httpRequestHeader = this.httpIn.readRequestHeader(bl);
                httpRequestHeader.setSenderAddress(this.inSocket.getInetAddress());
                if (httpRequestHeader.getMethod().equalsIgnoreCase("CONNECT")) {
                    HttpMessage httpMessage = new HttpMessage(httpRequestHeader);
                    httpMessage.setTimeSentMillis(System.currentTimeMillis());
                    try {
                        this.httpOut.write(CONNECT_HTTP_200);
                        this.httpOut.flush();
                        httpMessage.setResponseHeader(CONNECT_HTTP_200);
                        httpMessage.setTimeElapsedMillis((int)(System.currentTimeMillis() - httpMessage.getTimeSentMillis()));
                        this.notifyConnectMessage(httpMessage);
                        byte[] byArray = new byte[3];
                        bufferedInputStream.mark(3);
                        bufferedInputStream.read(byArray);
                        bufferedInputStream.reset();
                        if (ProxyThread.isSslTlsHandshake(byArray)) {
                            bl = true;
                            this.beginSSL(httpRequestHeader.getHostName());
                        }
                        httpRequestHeader = this.httpIn.readRequestHeader(bl);
                        httpRequestHeader.setSenderAddress(this.inSocket.getInetAddress());
                        this.processHttp(httpRequestHeader, bl);
                        break block21;
                    }
                    catch (MissingRootCertificateException missingRootCertificateException) {
                        HttpMessage httpMessage2 = new HttpMessage(httpRequestHeader);
                        ProxyThread.setErrorResponse(httpMessage2, BAD_GATEWAY_RESPONSE_STATUS, missingRootCertificateException, "ZAP SSL Error");
                        ProxyThread.writeHttpResponse(httpMessage2, this.httpOut);
                        throw new IOException(missingRootCertificateException);
                    }
                }
                this.processHttp(httpRequestHeader, bl);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (httpRequestHeader != null) {
                    if ("CONNECT".equalsIgnoreCase(httpRequestHeader.getMethod())) {
                        log.warn((Object)("Timeout reading (client) message after CONNECT to " + httpRequestHeader.getURI()));
                    } else {
                        log.warn((Object)("Timeout accessing " + httpRequestHeader.getURI()));
                    }
                } else {
                    log.warn((Object)"Socket timeout while reading first message.");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)socketTimeoutException, (Throwable)socketTimeoutException);
                    }
                }
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                log.warn((Object)"Malformed Header: ", (Throwable)httpMalformedHeaderException);
            }
            catch (HttpException httpException) {
                log.error((Object)httpException.getMessage(), (Throwable)httpException);
            }
            catch (IOException iOException) {
                log.debug((Object)"IOException: ", (Throwable)iOException);
            }
            finally {
                proxyThreadList.remove(this.thread);
                if (!this.keepSocketOpen) {
                    this.disconnect();
                }
            }
        }
    }

    private void notifyConnectMessage(HttpMessage httpMessage) {
        for (ConnectRequestProxyListener connectRequestProxyListener : this.parentServer.getConnectRequestProxyListeners()) {
            try {
                connectRequestProxyListener.receivedConnectRequest(httpMessage);
            }
            catch (Exception exception) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)exception);
            }
        }
    }

    private static void setErrorResponse(HttpMessage httpMessage, String string, Exception exception) throws HttpMalformedHeaderException {
        ProxyThread.setErrorResponse(httpMessage, string, exception, "ZAP Error");
    }

    private static void setErrorResponse(HttpMessage httpMessage, String string, Exception exception, String string2) throws HttpMalformedHeaderException {
        StringBuilder stringBuilder = new StringBuilder();
        if (exception instanceof SSLException) {
            stringBuilder.append(Constant.messages.getString("network.ssl.error.connect"));
            stringBuilder.append(httpMessage.getRequestHeader().getURI().toString()).append('\n');
            stringBuilder.append(Constant.messages.getString("network.ssl.error.exception")).append(exception.getMessage()).append('\n');
            stringBuilder.append(Constant.messages.getString("network.ssl.error.exception.rootcause")).append(ExceptionUtils.getRootCauseMessage((Throwable)exception)).append('\n');
            stringBuilder.append(Constant.messages.getString("network.ssl.error.help", Constant.messages.getString("network.ssl.error.help.url")));
            log.warn((Object)stringBuilder.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)exception, (Throwable)exception);
                stringBuilder.append("\n\nStack Trace:\n");
                for (String string3 : ExceptionUtils.getRootCauseStackTrace((Throwable)exception)) {
                    stringBuilder.append(string3).append('\n');
                }
            }
        } else {
            stringBuilder.append(string2).append(" [").append(exception.getClass().getName()).append("]: ").append(exception.getLocalizedMessage()).append("\n\nStack Trace:\n");
            for (String string4 : ExceptionUtils.getRootCauseStackTrace((Throwable)exception)) {
                stringBuilder.append(string4).append('\n');
            }
        }
        ProxyThread.setErrorResponse(httpMessage, string, stringBuilder.toString());
    }

    private static void setErrorResponse(HttpMessage httpMessage, String string, String string2) throws HttpMalformedHeaderException {
        HttpResponseHeader httpResponseHeader = new HttpResponseHeader("HTTP/1.1 " + string);
        httpResponseHeader.setHeader("Content-Type", "text/plain; charset=UTF-8");
        httpResponseHeader.setHeader("Content-Length", Integer.toString(string2.getBytes(StandardCharsets.UTF_8).length));
        httpMessage.setResponseHeader(httpResponseHeader);
        if (!"HEAD".equals(httpMessage.getRequestHeader().getMethod())) {
            httpMessage.setResponseBody(string2);
        }
    }

    private static void writeHttpResponse(HttpMessage httpMessage, HttpOutputStream httpOutputStream) throws IOException {
        httpOutputStream.write(httpMessage.getResponseHeader());
        httpOutputStream.flush();
        if (httpMessage.getResponseBody().length() > 0) {
            httpOutputStream.write(httpMessage.getResponseBody().getBytes());
            httpOutputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHttp(HttpRequestHeader httpRequestHeader, boolean bl) throws IOException {
        HttpRequestBody httpRequestBody = null;
        boolean bl2 = true;
        HttpMessage httpMessage = null;
        this.inSocket.setSoTimeout(2500);
        do {
            if (bl2) {
                bl2 = false;
            } else {
                try {
                    httpRequestHeader = this.httpIn.readRequestHeader(bl);
                    httpRequestHeader.setSenderAddress(this.inSocket.getInetAddress());
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Timed out while reading a new HTTP request.");
                    }
                    return;
                }
            }
            if (this.parentServer.isEnableApi() && API.getInstance().handleApiRequest(httpRequestHeader, this.httpIn, this.httpOut, this.isRecursive(httpRequestHeader))) {
                return;
            }
            httpMessage = new HttpMessage();
            httpMessage.setRequestHeader(httpRequestHeader);
            if (httpMessage.getRequestHeader().getContentLength() > 0) {
                httpRequestBody = this.httpIn.readRequestBody(httpRequestHeader);
                httpMessage.setRequestBody(httpRequestBody);
            }
            if (this.proxyParam.isRemoveUnsupportedEncodings()) {
                this.removeUnsupportedEncodings(httpMessage);
            }
            if (this.isProcessCache(httpMessage)) continue;
            this.semaphore = this.parentServer.isSerialize() ? semaphoreSingleton : this;
            boolean bl3 = true;
            Object object = this.semaphore;
            synchronized (object) {
                CharSequence charSequence;
                if (this.notifyOverrideListenersRequestSend(httpMessage)) {
                    bl3 = false;
                } else if (!this.notifyListenerRequestSend(httpMessage)) {
                    return;
                }
                try {
                    if (bl3) {
                        if (httpMessage.getResponseHeader().isEmpty()) {
                            this.getHttpSender().sendAndReceive(httpMessage);
                        }
                        this.decodeResponseIfNeeded(httpMessage);
                        if (!this.notifyOverrideListenersResponseReceived(httpMessage) && !this.notifyListenerResponseReceive(httpMessage)) {
                            return;
                        }
                    }
                }
                catch (HttpException httpException) {
                    throw httpException;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    charSequence = Constant.messages.getString("proxy.error.readtimeout", httpMessage.getRequestHeader().getURI(), this.connectionParam.getTimeoutInSecs());
                    log.warn((Object)charSequence);
                    ProxyThread.setErrorResponse(httpMessage, GATEWAY_TIMEOUT_RESPONSE_STATUS, (String)charSequence);
                    this.notifyListenerResponseReceive(httpMessage);
                }
                catch (IOException iOException) {
                    ProxyThread.setErrorResponse(httpMessage, BAD_GATEWAY_RESPONSE_STATUS, iOException);
                    this.notifyListenerResponseReceive(httpMessage);
                }
                try {
                    ProxyThread.writeHttpResponse(httpMessage, this.httpOut);
                }
                catch (IOException iOException) {
                    charSequence = new StringBuilder(200);
                    ((StringBuilder)charSequence).append("Failed to write/forward the HTTP response to the client: ");
                    ((StringBuilder)charSequence).append(iOException.getClass().getName());
                    if (iOException.getMessage() != null) {
                        ((StringBuilder)charSequence).append(": ").append(iOException.getMessage());
                    }
                    log.warn((Object)((StringBuilder)charSequence).toString());
                }
            }
            object = (ZapGetMethod)((Object)httpMessage.getUserObject());
            this.keepSocketOpen = this.notifyPersistentConnectionListener(httpMessage, this.inSocket, (ZapGetMethod)((Object)object));
            if (this.keepSocketOpen) break;
        } while (!this.isConnectionClose(httpMessage) && !this.inSocket.isClosed());
    }

    private FilterInputStream buildStreamDecoder(String string, ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (string.equalsIgnoreCase("deflate")) {
            return new InflaterInputStream(byteArrayInputStream, new Inflater(true));
        }
        return new GZIPInputStream(byteArrayInputStream);
    }

    private void decodeResponseIfNeeded(HttpMessage httpMessage) {
        String string = httpMessage.getResponseHeader().getHeader("Content-Encoding");
        if (this.proxyParam.isAlwaysDecodeGzip() && string != null && !string.equalsIgnoreCase("identity")) {
            string = Pattern.compile("^x-", 2).matcher(string).replaceAll("");
            if (!string.equalsIgnoreCase("deflate") && !string.equalsIgnoreCase("gzip")) {
                log.warn((Object)("Unsupported content encoding method: " + string));
                return;
            }
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(httpMessage.getResponseBody().getBytes());
                 FilterInputStream filterInputStream = this.buildStreamDecoder(string, byteArrayInputStream);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(filterInputStream);
                 ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                int n;
                byte[] byArray = new byte[1024];
                while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                httpMessage.setResponseBody(byteArrayOutputStream.toByteArray());
                httpMessage.getResponseHeader().setHeader("Content-Encoding", null);
                if (httpMessage.getResponseHeader().getHeader("Content-Length") != null) {
                    httpMessage.getResponseHeader().setHeader("Content-Length", Integer.toString(byteArrayOutputStream.size()));
                }
            }
            catch (IOException iOException) {
                log.error((Object)("Unable to uncompress gzip content: " + iOException.getMessage()), (Throwable)iOException);
            }
        }
    }

    private boolean isConnectionClose(HttpMessage httpMessage) {
        if (httpMessage == null || httpMessage.getResponseHeader().isEmpty()) {
            return true;
        }
        if (httpMessage.getRequestHeader().isConnectionClose()) {
            return true;
        }
        if (httpMessage.getResponseHeader().isConnectionClose()) {
            return true;
        }
        return httpMessage.getResponseHeader().getContentLength() == -1 && httpMessage.getResponseBody().length() > 0;
    }

    protected void disconnect() {
        block8: {
            block7: {
                try {
                    if (this.httpIn != null) {
                        this.httpIn.close();
                    }
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            try {
                if (this.httpOut != null) {
                    this.httpOut.close();
                }
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        HttpUtil.closeSocket(this.inSocket);
        if (this.httpSender != null) {
            this.httpSender.shutdown();
        }
    }

    private boolean notifyListenerRequestSend(HttpMessage httpMessage) {
        if (this.parentServer.excludeUrl(httpMessage.getRequestHeader().getURI())) {
            return true;
        }
        ProxyListener proxyListener = null;
        List<ProxyListener> list = this.parentServer.getListenerList();
        for (int i = 0; i < list.size(); ++i) {
            proxyListener = list.get(i);
            try {
                if (proxyListener.onHttpRequestSend(httpMessage)) continue;
                return false;
            }
            catch (Exception exception) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)exception);
            }
        }
        return true;
    }

    private boolean notifyListenerResponseReceive(HttpMessage httpMessage) {
        if (this.parentServer.excludeUrl(httpMessage.getRequestHeader().getURI())) {
            return true;
        }
        ProxyListener proxyListener = null;
        List<ProxyListener> list = this.parentServer.getListenerList();
        for (int i = 0; i < list.size(); ++i) {
            proxyListener = list.get(i);
            try {
                if (proxyListener.onHttpResponseReceive(httpMessage)) continue;
                return false;
            }
            catch (Exception exception) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)exception);
            }
        }
        return true;
    }

    private boolean notifyOverrideListenersRequestSend(HttpMessage httpMessage) {
        for (OverrideMessageProxyListener overrideMessageProxyListener : this.parentServer.getOverrideMessageProxyListeners()) {
            try {
                if (!overrideMessageProxyListener.onHttpRequestSend(httpMessage)) continue;
                return true;
            }
            catch (Exception exception) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)exception);
            }
        }
        return false;
    }

    private boolean notifyOverrideListenersResponseReceived(HttpMessage httpMessage) {
        for (OverrideMessageProxyListener overrideMessageProxyListener : this.parentServer.getOverrideMessageProxyListeners()) {
            try {
                if (!overrideMessageProxyListener.onHttpResponseReceived(httpMessage)) continue;
                return true;
            }
            catch (Exception exception) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)exception);
            }
        }
        return false;
    }

    private boolean notifyPersistentConnectionListener(HttpMessage httpMessage, Socket socket, ZapGetMethod zapGetMethod) {
        boolean bl = false;
        PersistentConnectionListener persistentConnectionListener = null;
        List<PersistentConnectionListener> list = this.parentServer.getPersistentConnectionListenerList();
        for (int i = 0; i < list.size(); ++i) {
            persistentConnectionListener = list.get(i);
            try {
                if (!persistentConnectionListener.onHandshakeResponse(httpMessage, socket, zapGetMethod)) continue;
                bl = true;
                break;
            }
            catch (Exception exception) {
                log.error((Object)"An error occurred while notifying listener:", (Throwable)exception);
            }
        }
        return bl;
    }

    private boolean isRecursive(HttpRequestHeader httpRequestHeader) {
        try {
            if (httpRequestHeader.getHostPort() == this.inSocket.getLocalPort()) {
                String string = httpRequestHeader.getHostName();
                if (API.API_DOMAIN.equals(string)) {
                    return true;
                }
                if (this.isProxyAddress(InetAddress.getByName(string))) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    private boolean isProxyAddress(InetAddress inetAddress) {
        return this.parentServer.getProxyParam().isProxyIpAnyLocalAddress() ? ProxyThread.isLocalAddress(inetAddress) || ProxyThread.isNetworkInterfaceAddress(inetAddress) || this.isOwnPublicAddress(inetAddress) : inetAddress.equals(this.inSocket.getLocalAddress());
    }

    private static boolean isLocalAddress(InetAddress inetAddress) {
        return inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress() || inetAddress.isAnyLocalAddress();
    }

    private static boolean isNetworkInterfaceAddress(InetAddress inetAddress) {
        try {
            if (NetworkInterface.getByInetAddress(inetAddress) != null) {
                return true;
            }
        }
        catch (SocketException socketException) {
            log.warn((Object)"Failed to check if an address is from a network interface:", (Throwable)socketException);
        }
        return false;
    }

    private boolean isOwnPublicAddress(InetAddress inetAddress) {
        if (!this.proxyParam.isBehindNat()) {
            return false;
        }
        TransportAddress transportAddress = ProxyThread.getAwsCandidateHarvester().getMask();
        if (transportAddress == null) {
            return false;
        }
        return Arrays.equals(inetAddress.getAddress(), transportAddress.getAddress().getAddress());
    }

    private static AwsCandidateHarvester getAwsCandidateHarvester() {
        if (awsCandidateHarvester == null) {
            ProxyThread.createAwsCandidateHarvester();
        }
        return awsCandidateHarvester;
    }

    private static synchronized void createAwsCandidateHarvester() {
        if (awsCandidateHarvester == null) {
            awsCandidateHarvester = new AwsCandidateHarvester();
        }
    }

    private void removeUnsupportedEncodings(HttpMessage httpMessage) {
        String string = httpMessage.getRequestHeader().getHeader("Accept-Encoding");
        if (string == null) {
            return;
        }
        httpMessage.getRequestHeader().setHeader("Accept-Encoding", null);
    }

    protected HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(this.connectionParam, true, 1);
        }
        return this.httpSender;
    }

    static boolean isAnyProxyThreadRunning() {
        return !proxyThreadList.isEmpty();
    }

    protected boolean isProcessCache(HttpMessage httpMessage) throws IOException {
        if (!this.parentServer.isEnableCacheProcessing()) {
            return false;
        }
        if (this.parentServer.getCacheProcessingList().isEmpty()) {
            return false;
        }
        CacheProcessingItem cacheProcessingItem = this.parentServer.getCacheProcessingList().get(0);
        if (httpMessage.equals(cacheProcessingItem.message)) {
            HttpMessage httpMessage2 = cacheProcessingItem.message.cloneAll();
            httpMessage.setResponseHeader(httpMessage2.getResponseHeader());
            httpMessage.setResponseBody(httpMessage2.getResponseBody());
            ProxyThread.writeHttpResponse(httpMessage, this.httpOut);
            return true;
        }
        try {
            RecordHistory recordHistory = Model.getSingleton().getDb().getTableHistory().getHistoryCache(cacheProcessingItem.reference, httpMessage);
            if (recordHistory == null) {
                return false;
            }
            httpMessage.setResponseHeader(recordHistory.getHttpMessage().getResponseHeader());
            httpMessage.setResponseBody(recordHistory.getHttpMessage().getResponseBody());
            ProxyThread.writeHttpResponse(httpMessage, this.httpOut);
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

