/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsAPI;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsPanel;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsParam;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;
import org.zaproxy.zap.extension.httpsessions.OptionsHttpSessionsPanel;
import org.zaproxy.zap.extension.httpsessions.PopupMenuFactoryAddUserFromSession;
import org.zaproxy.zap.extension.httpsessions.PopupMenuItemCopySessionToken;
import org.zaproxy.zap.extension.httpsessions.PopupMenuRemoveSession;
import org.zaproxy.zap.extension.httpsessions.PopupMenuSetActiveSession;
import org.zaproxy.zap.extension.httpsessions.PopupMenuUnsetActiveSession;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.network.HttpSenderListener;
import org.zaproxy.zap.view.ScanPanel;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;

public class ExtensionHttpSessions
extends ExtensionAdaptor
implements SessionChangedListener,
SiteMapListener,
HttpSenderListener {
    public static final String NAME = "ExtensionHttpSessions";
    private static final Logger log = Logger.getLogger(ExtensionHttpSessions.class);
    private HttpSessionsPanel httpSessionsPanel;
    private OptionsHttpSessionsPanel optionsHttpSessionsPanel;
    private Map<String, HttpSessionsSite> sessions;
    private Object sessionLock = new Object();
    private Map<String, HttpSessionTokensSet> sessionTokens;
    private Map<String, HashSet<String>> removedDefaultTokens;
    private HttpSessionsParam param;
    private PopupMenuSetActiveSession popupMenuSetActiveSession;
    private PopupMenuUnsetActiveSession popupMenuUnsetActiveSession;
    private PopupMenuRemoveSession popupMenuRemoveSession;
    private PopupMenuFactoryAddUserFromSession popupMenuAddUserFromSession;
    private PopupMenuItemCopySessionToken popupMenuItemCopySessionToken;

    public ExtensionHttpSessions() {
        super(NAME);
        this.initialize();
    }

    private void initialize() {
        this.setOrder(68);
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("httpsessions.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void init() {
        super.init();
        this.sessionTokens = new HashMap<String, HttpSessionTokensSet>();
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getParam());
        extensionHook.addSessionListener(this);
        extensionHook.addSiteMapListener(this);
        HttpSender.addListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addStatusPanel(this.getHttpSessionsPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsHttpSessionsPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuSetActiveSession());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuUnsetActiveSession());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuRemoveSession());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAddUserFromSession());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuItemCopySessionToken());
        }
        extensionHook.addApiImplementor(new HttpSessionsAPI(this));
    }

    private OptionsHttpSessionsPanel getOptionsHttpSessionsPanel() {
        if (this.optionsHttpSessionsPanel == null) {
            this.optionsHttpSessionsPanel = new OptionsHttpSessionsPanel();
        }
        return this.optionsHttpSessionsPanel;
    }

    private PopupMenuSetActiveSession getPopupMenuSetActiveSession() {
        if (this.popupMenuSetActiveSession == null) {
            this.popupMenuSetActiveSession = new PopupMenuSetActiveSession();
            this.popupMenuSetActiveSession.setExtension(this);
        }
        return this.popupMenuSetActiveSession;
    }

    private PopupMenuRemoveSession getPopupMenuRemoveSession() {
        if (this.popupMenuRemoveSession == null) {
            this.popupMenuRemoveSession = new PopupMenuRemoveSession();
            this.popupMenuRemoveSession.setExtension(this);
        }
        return this.popupMenuRemoveSession;
    }

    private PopupMenuUnsetActiveSession getPopupMenuUnsetActiveSession() {
        if (this.popupMenuUnsetActiveSession == null) {
            this.popupMenuUnsetActiveSession = new PopupMenuUnsetActiveSession();
            this.popupMenuUnsetActiveSession.setExtension(this);
        }
        return this.popupMenuUnsetActiveSession;
    }

    private PopupMenuFactoryAddUserFromSession getPopupMenuAddUserFromSession() {
        if (this.popupMenuAddUserFromSession == null) {
            this.popupMenuAddUserFromSession = new PopupMenuFactoryAddUserFromSession(this);
        }
        return this.popupMenuAddUserFromSession;
    }

    private PopupMenuItemCopySessionToken getPopupMenuItemCopySessionToken() {
        if (this.popupMenuItemCopySessionToken == null) {
            this.popupMenuItemCopySessionToken = new PopupMenuItemCopySessionToken(this.getHttpSessionsPanel());
        }
        return this.popupMenuItemCopySessionToken;
    }

    public HttpSessionsParam getParam() {
        if (this.param == null) {
            this.param = new HttpSessionsParam();
        }
        return this.param;
    }

    public boolean isDefaultSessionToken(String string) {
        return this.getParam().getDefaultTokensEnabled().contains(string.toLowerCase(Locale.ENGLISH));
    }

    private boolean isRemovedDefaultSessionToken(String string, String string2) {
        if (this.removedDefaultTokens == null) {
            return false;
        }
        HashSet<String> hashSet = this.removedDefaultTokens.get(string);
        return hashSet != null && hashSet.contains(string2);
    }

    private void markRemovedDefaultSessionToken(String string, String string2) {
        HashSet<String> hashSet;
        if (this.removedDefaultTokens == null) {
            this.removedDefaultTokens = new HashMap<String, HashSet<String>>(1);
        }
        if ((hashSet = this.removedDefaultTokens.get(string)) == null) {
            hashSet = new HashSet(1);
            this.removedDefaultTokens.put(string, hashSet);
        }
        hashSet.add(string2);
    }

    private void unmarkRemovedDefaultSessionToken(String string, String string2) {
        if (this.removedDefaultTokens == null) {
            return;
        }
        HashSet<String> hashSet = this.removedDefaultTokens.get(string);
        if (hashSet == null) {
            return;
        }
        hashSet.remove(string2);
    }

    public boolean isSessionToken(String string, String string2) {
        HttpSessionTokensSet httpSessionTokensSet;
        if (!string.contains(":")) {
            string = string + ":80";
        }
        if ((httpSessionTokensSet = this.sessionTokens.get(string)) == null) {
            return false;
        }
        return httpSessionTokensSet.isSessionToken(string2);
    }

    public void addHttpSessionToken(String string, String string2) {
        HttpSessionTokensSet httpSessionTokensSet;
        if (!string.contains(":")) {
            string = string + ":80";
        }
        if ((httpSessionTokensSet = this.sessionTokens.get(string)) == null) {
            httpSessionTokensSet = new HttpSessionTokensSet();
            this.sessionTokens.put(string, httpSessionTokensSet);
        }
        log.info((Object)("Added new session token for site '" + string + "': " + string2));
        httpSessionTokensSet.addToken(string2);
        this.unmarkRemovedDefaultSessionToken(string, string2);
    }

    public void removeHttpSessionToken(String string, String string2) {
        HttpSessionTokensSet httpSessionTokensSet;
        if (!string.contains(":")) {
            string = string + ":80";
        }
        if ((httpSessionTokensSet = this.sessionTokens.get(string)) != null) {
            httpSessionTokensSet.removeToken(string2);
            if (httpSessionTokensSet.isEmpty()) {
                this.sessionTokens.remove(string);
            }
            this.getHttpSessionsSite(string).cleanupSessionToken(string2);
        }
        if (this.isDefaultSessionToken(string2)) {
            this.markRemovedDefaultSessionToken(string, string2);
        }
        log.info((Object)("Removed session token for site '" + string + "': " + string2));
    }

    public final HttpSessionTokensSet getHttpSessionTokensSet(String string) {
        if (!string.contains(":")) {
            string = string + ":80";
        }
        return this.sessionTokens.get(string);
    }

    protected HttpSessionsPanel getHttpSessionsPanel() {
        if (this.httpSessionsPanel == null) {
            this.httpSessionsPanel = new HttpSessionsPanel(this);
        }
        return this.httpSessionsPanel;
    }

    public HttpSessionsSite getHttpSessionsSite(String string) {
        return this.getHttpSessionsSite(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSessionsSite getHttpSessionsSite(String string, boolean bl) {
        if (!string.contains(":")) {
            string = string + ":80";
        }
        Object object = this.sessionLock;
        synchronized (object) {
            HttpSessionsSite httpSessionsSite;
            if (this.sessions == null) {
                if (!bl) {
                    return null;
                }
                this.sessions = new HashMap<String, HttpSessionsSite>();
            }
            if ((httpSessionsSite = this.sessions.get(string)) == null) {
                if (!bl) {
                    return null;
                }
                httpSessionsSite = new HttpSessionsSite(this, string);
                this.sessions.put(string, httpSessionsSite);
            }
            return httpSessionsSite;
        }
    }

    @Override
    public void nodeSelected(SiteNode siteNode) {
        this.getHttpSessionsPanel().nodeSelected(siteNode);
    }

    @Override
    public void onReturnNodeRendererComponent(SiteMapTreeCellRenderer siteMapTreeCellRenderer, boolean bl, SiteNode siteNode) {
    }

    @Override
    public void sessionChanged(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionAboutToChange(Session session) {
        this.sessionTokens = new HashMap<String, HttpSessionTokensSet>();
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessions = null;
        }
        this.removedDefaultTokens = null;
        if (this.getView() != null) {
            this.getHttpSessionsPanel().reset();
        }
        HttpSessionsSite.resetLastGeneratedSessionId();
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpSession> getHttpSessionsForContext(Context context) {
        LinkedList<HttpSession> linkedList = new LinkedList<HttpSession>();
        if (this.sessions == null) {
            return linkedList;
        }
        Object object = this.sessionLock;
        synchronized (object) {
            for (Map.Entry<String, HttpSessionsSite> entry : this.sessions.entrySet()) {
                String string = entry.getKey();
                string = "http://" + string;
                if (!context.isInContext(string)) continue;
                linkedList.addAll(entry.getValue().getHttpSessions());
            }
        }
        return linkedList;
    }

    public HttpSessionTokensSet getHttpSessionTokensSetForContext(Context context) {
        for (Map.Entry<String, HttpSessionTokensSet> entry : this.sessionTokens.entrySet()) {
            String string = entry.getKey();
            string = "http://" + string;
            if (!context.isInContext(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSites() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.sessions == null) {
            return arrayList;
        }
        Object object = this.sessionLock;
        synchronized (object) {
            arrayList.addAll(this.sessions.keySet());
        }
        return arrayList;
    }

    @Override
    public int getListenerOrder() {
        return 1;
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage, int n, HttpSender httpSender) {
        if (n == 7 || n == 5) {
            return;
        }
        String string = httpMessage.getRequestHeader().getHostName() + ":" + httpMessage.getRequestHeader().getHostPort();
        string = ScanPanel.cleanSiteName(string, true);
        if (this.getView() != null) {
            this.getHttpSessionsPanel().addSiteAsynchronously(string);
        }
        if (this.getParam().isEnabledProxyOnly() && n != 1) {
            return;
        }
        List<HttpCookie> list = httpMessage.getRequestHeader().getHttpCookies();
        for (HttpCookie httpCookie : list) {
            if (!this.isDefaultSessionToken(httpCookie.getName()) || this.isSessionToken(string, httpCookie.getName()) || this.isRemovedDefaultSessionToken(string, httpCookie.getName())) continue;
            this.addHttpSessionToken(string, httpCookie.getName());
        }
        HttpSessionsSite httpSessionsSite = this.getHttpSessionsSite(string);
        httpSessionsSite.processHttpRequestMessage(httpMessage);
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage, int n, HttpSender httpSender) {
        if (n == 2 || n == 3 || n == 10 || n == 11 || n == 7 || n == 4 || n == 5) {
            return;
        }
        String string = httpMessage.getRequestHeader().getHostName() + ":" + httpMessage.getRequestHeader().getHostPort();
        string = ScanPanel.cleanSiteName(string, true);
        if (this.getView() != null) {
            this.getHttpSessionsPanel().addSiteAsynchronously(string);
        }
        if (this.getParam().isEnabledProxyOnly() && n != 1) {
            return;
        }
        List<HttpCookie> list = httpMessage.getResponseHeader().getHttpCookies(httpMessage.getRequestHeader().getHostName());
        for (HttpCookie httpCookie : list) {
            if (!this.isDefaultSessionToken(httpCookie.getName()) || this.isSessionToken(string, httpCookie.getName()) || this.isRemovedDefaultSessionToken(string, httpCookie.getName())) continue;
            this.addHttpSessionToken(string, httpCookie.getName());
        }
        HttpSessionsSite httpSessionsSite = this.getHttpSessionsSite(string);
        httpSessionsSite.processHttpResponseMessage(httpMessage);
    }
}

