/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.keyboard.ExtensionKeyboard;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcut;

public class KeyboardAPI
extends ApiImplementor {
    private static final String PREFIX = "keyboard";
    private static final String OTHER_CHEETSHEET_ACTION_ORDER = "cheatsheetActionOrder";
    private static final String OTHER_CHEETSHEET_KEY_ORDER = "cheatsheetKeyOrder";
    private static final String PARAM_INC_UNSET = "incUnset";
    private ExtensionKeyboard extension;

    public KeyboardAPI(ExtensionKeyboard extensionKeyboard) {
        this.extension = extensionKeyboard;
        this.addApiOthers(new ApiOther(OTHER_CHEETSHEET_ACTION_ORDER, null, new String[]{PARAM_INC_UNSET}));
        this.addApiOthers(new ApiOther(OTHER_CHEETSHEET_KEY_ORDER, null, new String[]{PARAM_INC_UNSET}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    public URI getCheatSheetActionURI() throws URIException, NullPointerException {
        return new URI(API.getInstance().getBaseURL(API.Format.OTHER, PREFIX, API.RequestType.other, OTHER_CHEETSHEET_ACTION_ORDER, false), true);
    }

    public URI getCheatSheetKeyURI() throws URIException, NullPointerException {
        return new URI(API.getInstance().getBaseURL(API.Format.OTHER, PREFIX, API.RequestType.other, OTHER_CHEETSHEET_KEY_ORDER, false), true);
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage httpMessage, String string, JSONObject jSONObject) throws ApiException {
        if (OTHER_CHEETSHEET_ACTION_ORDER.equals(string) || OTHER_CHEETSHEET_KEY_ORDER.equals(string)) {
            List<KeyboardShortcut> list = this.extension.getShortcuts();
            if (OTHER_CHEETSHEET_ACTION_ORDER.equals(string)) {
                Collections.sort(list, new Comparator<KeyboardShortcut>(){

                    @Override
                    public int compare(KeyboardShortcut keyboardShortcut, KeyboardShortcut keyboardShortcut2) {
                        return keyboardShortcut.getName().compareTo(keyboardShortcut2.getName());
                    }
                });
            } else {
                Collections.sort(list, new Comparator<KeyboardShortcut>(){

                    @Override
                    public int compare(KeyboardShortcut keyboardShortcut, KeyboardShortcut keyboardShortcut2) {
                        return keyboardShortcut.getKeyStrokeKeyCodeString().compareTo(keyboardShortcut2.getKeyStrokeKeyCodeString());
                    }
                });
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Constant.messages.getString("keyboard.api.cheatsheet.header"));
            boolean bl = this.getParam(jSONObject, PARAM_INC_UNSET, false);
            for (KeyboardShortcut keyboardShortcut : list) {
                if (!bl && keyboardShortcut.getKeyStrokeKeyCodeString().length() <= 0) continue;
                stringBuilder.append(MessageFormat.format(Constant.messages.getString("keyboard.api.cheatsheet.tablerow"), keyboardShortcut.getName(), keyboardShortcut.getKeyStrokeModifiersString(), keyboardShortcut.getKeyStrokeKeyCodeString()));
            }
            stringBuilder.append(Constant.messages.getString("keyboard.api.cheatsheet.footer"));
            try {
                httpMessage.setResponseHeader(API.getDefaultResponseHeader("text/html", stringBuilder.length()));
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, string, httpMalformedHeaderException);
            }
            httpMessage.setResponseBody(stringBuilder.toString());
            return httpMessage;
        }
        throw new ApiException(ApiException.Type.BAD_OTHER, string);
    }
}

