/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.FormControlType;
import org.apache.commons.httpclient.URI;
import org.zaproxy.zap.model.ValueGenerator;

public class DefaultValueGenerator
implements ValueGenerator {
    private static final String ATTR_TYPE = "type";
    private static final String DEFAULT_NUMBER_VALUE = "1";
    private static final String DEFAULT_TEXT_VALUE = "ZAP";
    private static final String DEFAULT_PASS_VALUE = "ZAP";
    private static final String DEFAULT_FILE_VALUE = "test_file.txt";
    private static final String DEFAULT_EMPTY_VALUE = "";
    private Date defaultDate;

    public Date getDefaultDate() {
        if (this.defaultDate == null) {
            return new Date();
        }
        return this.defaultDate;
    }

    public void setDefaultDate(Date date) {
        this.defaultDate = date;
    }

    @Override
    public String getValue(URI uRI, String string, String string2, String string3, List<String> list, Map<String, String> map, Map<String, String> map2) {
        if (!string3.isEmpty()) {
            return string3;
        }
        if (map2.get("Control Type").equalsIgnoreCase(FormControlType.TEXT.toString())) {
            String string4 = map2.get(ATTR_TYPE);
            if (string4 == null || string4.equalsIgnoreCase("text")) {
                return "ZAP";
            }
            if (string4.equalsIgnoreCase("number") || string4.equalsIgnoreCase("range")) {
                String string5 = map2.get("min");
                if (string5 != null) {
                    return string5;
                }
                String string6 = map2.get("max");
                if (string6 != null) {
                    return string6;
                }
                return DEFAULT_NUMBER_VALUE;
            }
            if (string4.equalsIgnoreCase("url")) {
                return "http://www.example.com";
            }
            if (string4.equalsIgnoreCase("email")) {
                return "foo-bar@example.com";
            }
            if (string4.equalsIgnoreCase("color")) {
                return "#ffffff";
            }
            if (string4.equalsIgnoreCase("tel")) {
                return "9999999999";
            }
            if (string4.equalsIgnoreCase("datetime")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return simpleDateFormat.format(this.getDefaultDate());
            }
            if (string4.equalsIgnoreCase("datetime-local")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                return simpleDateFormat.format(this.getDefaultDate());
            }
            if (string4.equalsIgnoreCase("date")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                return simpleDateFormat.format(this.getDefaultDate());
            }
            if (string4.equalsIgnoreCase("time")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                return simpleDateFormat.format(this.getDefaultDate());
            }
            if (string4.equalsIgnoreCase("month")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
                return simpleDateFormat.format(this.getDefaultDate());
            }
            if (string4.equalsIgnoreCase("week")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-'W'ww");
                return simpleDateFormat.format(this.getDefaultDate());
            }
        } else {
            if (map2.get("Control Type").equalsIgnoreCase(FormControlType.PASSWORD.toString())) {
                return "ZAP";
            }
            if (map2.get("Control Type").equalsIgnoreCase(FormControlType.FILE.toString())) {
                return DEFAULT_FILE_VALUE;
            }
        }
        return DEFAULT_EMPTY_VALUE;
    }
}

