/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.net.CookieManager;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.spider.SpiderController;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.SpiderTask;
import org.zaproxy.zap.spider.filters.DefaultFetchFilter;
import org.zaproxy.zap.spider.filters.DefaultParseFilter;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class Spider {
    private SpiderParam spiderParam;
    private ConnectionParam connectionParam;
    private Model model;
    private List<SpiderListener> listeners;
    private volatile boolean paused;
    private volatile boolean stopped;
    private ReentrantLock pauseLock = new ReentrantLock();
    private SpiderController controller;
    private Condition pausedCondition = this.pauseLock.newCondition();
    private ExecutorService threadPool;
    private DefaultFetchFilter defaultFetchFilter;
    private LinkedHashSet<URI> seedList;
    private ExtensionSpider extension;
    private static final Logger log = Logger.getLogger(Spider.class);
    private HttpSender httpSender;
    private int tasksDoneCount;
    private int tasksTotalCount;
    private CookieManager cookieManager;
    private Context scanContext;
    private User scanUser;
    private long timeStarted;
    private boolean initialized;
    private static final Pattern svnUrlPattern = Pattern.compile("\\.svn/");
    private static final Pattern gitUrlPattern = Pattern.compile("\\.git/");
    private final String id;

    @Deprecated
    public Spider(ExtensionSpider extensionSpider, SpiderParam spiderParam, ConnectionParam connectionParam, Model model, Context context) {
        this("?", extensionSpider, spiderParam, connectionParam, model, context);
    }

    public Spider(String string, ExtensionSpider extensionSpider, SpiderParam spiderParam, ConnectionParam connectionParam, Model model, Context context) {
        log.info((Object)"Spider initializing...");
        this.id = string;
        this.spiderParam = spiderParam;
        this.connectionParam = connectionParam;
        this.model = model;
        this.extension = extensionSpider;
        this.controller = new SpiderController(this, extensionSpider.getCustomParsers());
        this.listeners = new LinkedList<SpiderListener>();
        this.seedList = new LinkedHashSet();
        this.cookieManager = new CookieManager();
        this.scanContext = context;
        this.init();
    }

    private void init() {
        this.paused = false;
        this.stopped = true;
        this.tasksDoneCount = 0;
        this.tasksTotalCount = 0;
        this.initialized = false;
        this.defaultFetchFilter = new DefaultFetchFilter();
        this.addFetchFilter(this.defaultFetchFilter);
        for (FetchFilter object : this.extension.getCustomFetchFilters()) {
            this.addFetchFilter(object);
        }
        this.addParseFilter(new DefaultParseFilter());
        for (ParseFilter parseFilter : this.extension.getCustomParseFilters()) {
            this.addParseFilter(parseFilter);
        }
        this.defaultFetchFilter.setScanContext(this.scanContext);
        this.defaultFetchFilter.setDomainsAlwaysInScope(this.spiderParam.getDomainsAlwaysInScopeEnabled());
    }

    public void addSeed(HttpMessage httpMessage) {
        URI uRI = httpMessage.getRequestHeader().getURI();
        this.addSeed(uRI);
    }

    public void addSeed(URI uRI) {
        String string = null;
        try {
            string = uRI.getHost();
            this.defaultFetchFilter.addScopeRegex(string);
        }
        catch (URIException uRIException) {
            log.error((Object)("There was an error while adding seed value: " + uRI), (Throwable)uRIException);
            return;
        }
        this.seedList.add(uRI);
        if (this.getSpiderParam().isParseRobotsTxt()) {
            this.addRootFileSeed(uRI, "robots.txt");
        }
        if (this.getSpiderParam().isParseSitemapXml()) {
            this.addRootFileSeed(uRI, "sitemap.xml");
        }
        if (this.getSpiderParam().isParseSVNEntries()) {
            this.addFileSeed(uRI, ".svn/entries", svnUrlPattern);
            this.addFileSeed(uRI, ".svn/wc.db", svnUrlPattern);
        }
        if (this.getSpiderParam().isParseGit()) {
            this.addFileSeed(uRI, ".git/index", gitUrlPattern);
        }
    }

    private void addRootFileSeed(URI uRI, String string) {
        String string2 = Spider.buildUri(uRI.getScheme(), uRI.getRawHost(), uRI.getPort(), "/" + string);
        try {
            this.seedList.add(new URI(string2, true));
        }
        catch (Exception exception) {
            log.warn((Object)("Error while creating [" + string + "] seed: " + string2), (Throwable)exception);
        }
    }

    private static String buildUri(String string, char[] cArray, int n, String string2) {
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append(string).append("://").append(cArray);
        if (!Spider.isDefaultPort(string, n)) {
            stringBuilder.append(':').append(n);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void addFileSeed(URI uRI, String string, Pattern pattern) {
        String string2;
        String string3;
        String string4 = uRI.getEscapedPath();
        if (string4 == null) {
            string4 = "";
        }
        if ((string3 = uRI.getEscapedName()) == null) {
            string3 = "";
        }
        if ((string2 = string4.substring(0, string4.lastIndexOf(string3))).isEmpty()) {
            string2 = "/";
        }
        if (pattern.matcher(string2).find()) {
            return;
        }
        String string5 = Spider.buildUri(uRI.getScheme(), uRI.getRawHost(), uRI.getPort(), string2 + string);
        try {
            this.seedList.add(new URI(string5, true));
        }
        catch (Exception exception) {
            log.warn((Object)("Error while creating a seed URI for file [" + string + "] from [" + uRI + "] using [" + string5 + "]:"), (Throwable)exception);
        }
    }

    private static boolean isDefaultPort(String string, int n) {
        if (n == -1) {
            return true;
        }
        if ("http".equalsIgnoreCase(string)) {
            return n == 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return n == 443;
        }
        return false;
    }

    public void setExcludeList(List<String> list) {
        log.debug((Object)("New Exclude list: " + list));
        this.defaultFetchFilter.setExcludeRegexes(list);
    }

    public void addFetchFilter(FetchFilter fetchFilter) {
        this.controller.addFetchFilter(fetchFilter);
    }

    public void addParseFilter(ParseFilter parseFilter) {
        this.controller.addParseFilter(parseFilter);
    }

    protected HttpSender getHttpSender() {
        return this.httpSender;
    }

    protected SpiderParam getSpiderParam() {
        return this.spiderParam;
    }

    protected ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    protected SpiderController getController() {
        return this.controller;
    }

    protected CookieManager getCookieManager() {
        return this.cookieManager;
    }

    protected Model getModel() {
        return this.model;
    }

    protected synchronized void submitTask(SpiderTask spiderTask) {
        block4: {
            if (this.isStopped()) {
                log.debug((Object)("Submitting task skipped (" + spiderTask + ") as the Spider process is stopped."));
                return;
            }
            if (this.isTerminated()) {
                log.debug((Object)("Submitting task skipped (" + spiderTask + ") as the Spider process is terminated."));
                return;
            }
            ++this.tasksTotalCount;
            try {
                this.threadPool.execute(spiderTask);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Submitted task was rejected (" + spiderTask + "), spider state: [stopped=" + this.isStopped() + ", terminated=" + this.isTerminated() + "]."));
            }
        }
    }

    protected ExtensionSpider getExtensionSpider() {
        return this.extension;
    }

    public void start() {
        log.info((Object)"Starting spider...");
        this.timeStarted = System.currentTimeMillis();
        this.fetchFilterSeeds();
        if (this.seedList == null || this.seedList.isEmpty()) {
            log.warn((Object)"No seeds available for the Spider. Cancelling scan...");
            this.notifyListenersSpiderComplete(false);
            this.notifyListenersSpiderProgress(100, 0, 0);
            return;
        }
        if (this.scanUser != null) {
            log.info((Object)("Scan will be performed from the point of view of User: " + this.scanUser.getName()));
        }
        this.controller.init();
        this.stopped = false;
        this.paused = false;
        this.initialized = false;
        this.threadPool = Executors.newFixedThreadPool(this.spiderParam.getThreadCount(), new SpiderThreadFactory("ZAP-SpiderThreadPool-" + this.id + "-thread-"));
        this.httpSender = new HttpSender(this.connectionParam, true, 3);
        this.httpSender.setFollowRedirect(false);
        for (URI uRI : this.seedList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding seed for spider: " + uRI));
            }
            this.controller.addSeed(uRI, "GET");
        }
        this.initialized = true;
    }

    private void fetchFilterSeeds() {
        if (this.seedList == null || this.seedList.isEmpty()) {
            return;
        }
        Iterator iterator = this.seedList.iterator();
        block0: while (iterator.hasNext()) {
            URI uRI = (URI)iterator.next();
            for (FetchFilter fetchFilter : this.controller.getFetchFilters()) {
                FetchFilter.FetchStatus fetchStatus = fetchFilter.checkFilter(uRI);
                if (fetchStatus == FetchFilter.FetchStatus.VALID) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Seed: " + uRI + " was filtered with reason: " + (Object)((Object)fetchStatus)));
                }
                iterator.remove();
                continue block0;
            }
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        log.info((Object)"Stopping spidering process by request.");
        if (this.paused) {
            this.resume();
        }
        this.threadPool.shutdown();
        try {
            if (!this.threadPool.awaitTermination(2L, TimeUnit.SECONDS)) {
                log.warn((Object)"Failed to await for all spider threads to stop in the given time (2s)...");
                for (Runnable runnable : this.threadPool.shutdownNow()) {
                    ((SpiderTask)runnable).cleanup();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            log.warn((Object)"Interrupted while awaiting for all spider threads to stop...");
        }
        if (this.httpSender != null) {
            this.getHttpSender().shutdown();
            this.httpSender = null;
        }
        this.controller.reset();
        this.threadPool = null;
        this.notifyListenersSpiderComplete(false);
    }

    private void complete() {
        if (this.stopped) {
            return;
        }
        log.info((Object)"Spidering process is complete. Shutting down...");
        this.stopped = true;
        if (this.httpSender != null) {
            this.getHttpSender().shutdown();
            this.httpSender = null;
        }
        this.controller.reset();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (Spider.this.threadPool != null) {
                    Spider.this.threadPool.shutdown();
                }
                Spider.this.notifyListenersSpiderComplete(true);
                Spider.this.controller.reset();
                Spider.this.threadPool = null;
            }
        }, "ZAP-SpiderShutdownThread-" + this.id).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.pauseLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.pauseLock.lock();
        try {
            this.paused = false;
            this.pausedCondition.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void setScanAsUser(User user) {
        this.scanUser = user;
    }

    protected User getScanUser() {
        return this.scanUser;
    }

    protected void preTaskExecution() {
        this.checkPauseAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPauseAndWait() {
        this.pauseLock.lock();
        try {
            while (this.paused && !this.stopped) {
                this.pausedCondition.await();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    protected synchronized void postTaskExecution() {
        if (this.stopped) {
            return;
        }
        ++this.tasksDoneCount;
        int n = this.tasksDoneCount * 100 / this.tasksTotalCount;
        this.notifyListenersSpiderProgress(n, this.tasksDoneCount, this.tasksTotalCount - this.tasksDoneCount);
        if (this.tasksDoneCount == this.tasksTotalCount && this.initialized) {
            this.complete();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        if (!this.stopped && this.spiderParam.getMaxDuration() > 0 && TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.timeStarted) > (long)this.spiderParam.getMaxDuration()) {
            log.info((Object)("Spidering process has exceeded maxDuration of " + this.spiderParam.getMaxDuration() + " minute(s)"));
            this.complete();
        }
        return this.stopped;
    }

    public boolean isTerminated() {
        return this.threadPool.isTerminated();
    }

    public void addSpiderListener(SpiderListener spiderListener) {
        this.listeners.add(spiderListener);
    }

    public void removeSpiderListener(SpiderListener spiderListener) {
        this.listeners.remove(spiderListener);
    }

    protected synchronized void notifyListenersSpiderProgress(int n, int n2, int n3) {
        for (SpiderListener spiderListener : this.listeners) {
            spiderListener.spiderProgress(n, n2, n3);
        }
    }

    protected synchronized void notifyListenersFoundURI(String string, String string2, FetchFilter.FetchStatus fetchStatus) {
        for (SpiderListener spiderListener : this.listeners) {
            spiderListener.foundURI(string, string2, fetchStatus);
        }
    }

    protected synchronized void notifyListenersReadURI(HttpMessage httpMessage) {
        for (SpiderListener spiderListener : this.listeners) {
            spiderListener.readURI(httpMessage);
        }
    }

    protected synchronized void notifyListenersSpiderComplete(boolean bl) {
        for (SpiderListener spiderListener : this.listeners) {
            spiderListener.spiderComplete(bl);
        }
    }

    public void addCustomParser(SpiderParser spiderParser) {
        this.controller.addSpiderParser(spiderParser);
    }

    private static class SpiderThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final ThreadGroup group;

        public SpiderThreadFactory(String string) {
            this.namePrefix = string;
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

