/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.awt.Dialog;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractFormDialog;

class DialogAddPermittedAddress
extends AbstractFormDialog {
    private static final long serialVersionUID = -7356390753317082681L;
    private static final String DIALOG_TITLE = Constant.messages.getString("api.options.addr.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("api.options.addr.add.button.confirm");
    private static final String DOMAIN_FIELD_LABEL = Constant.messages.getString("api.options.addr.field.label.domain");
    private static final String REGEX_FIELD_LABEL = Constant.messages.getString("api.options.addr.field.label.regex");
    private static final String ENABLED_FIELD_LABEL = Constant.messages.getString("api.options.addr.field.label.enabled");
    private static final String TITLE_INVALID_REGEX_DIALOG = Constant.messages.getString("api.options.addr.warning.invalid.regex.title");
    private static final String TEXT_INVALID_REGEX_DIALOG = Constant.messages.getString("api.options.addr.warning.invalid.regex.text");
    private ZapTextField addressTextField;
    private JCheckBox regexCheckBox;
    private JCheckBox enabledCheckBox;
    protected DomainMatcher address;
    private ConfirmButtonValidatorDocListener confirmButtonValidatorDocListener;

    public DialogAddPermittedAddress(Dialog dialog) {
        super(dialog, DIALOG_TITLE);
    }

    protected DialogAddPermittedAddress(Dialog dialog, String string) {
        super(dialog, string);
    }

    @Override
    protected JPanel getFieldsPanel() {
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        JLabel jLabel = new JLabel(DOMAIN_FIELD_LABEL);
        JLabel jLabel2 = new JLabel(REGEX_FIELD_LABEL);
        JLabel jLabel3 = new JLabel(ENABLED_FIELD_LABEL);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel).addComponent(jLabel3).addComponent(jLabel2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getAddressTextField()).addComponent(this.getEnabledCheckBox()).addComponent(this.getRegexCheckBox())));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.getAddressTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.getRegexCheckBox())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.getEnabledCheckBox())));
        return jPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.getAddressTextField().setText("");
        this.getRegexCheckBox().setSelected(false);
        this.getEnabledCheckBox().setSelected(true);
        this.address = null;
    }

    @Override
    protected boolean validateFields() {
        if (this.getRegexCheckBox().isSelected()) {
            try {
                DomainMatcher.createPattern(this.getAddressTextField().getText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, TEXT_INVALID_REGEX_DIALOG, TITLE_INVALID_REGEX_DIALOG, 1);
                this.getAddressTextField().requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void performAction() {
        String string = this.getAddressTextField().getText();
        if (this.getRegexCheckBox().isSelected()) {
            Pattern pattern = DomainMatcher.createPattern(string);
            this.address = new DomainMatcher(pattern);
        } else {
            this.address = new DomainMatcher(string);
        }
        this.address.setEnabled(this.getEnabledCheckBox().isSelected());
    }

    @Override
    protected void clearFields() {
        this.getAddressTextField().setText("");
        this.getAddressTextField().discardAllEdits();
    }

    public DomainMatcher getAddress() {
        return this.address;
    }

    protected ZapTextField getAddressTextField() {
        if (this.addressTextField == null) {
            this.addressTextField = new ZapTextField(25);
            this.addressTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.addressTextField;
    }

    protected JCheckBox getRegexCheckBox() {
        if (this.regexCheckBox == null) {
            this.regexCheckBox = new JCheckBox();
        }
        return this.regexCheckBox;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.enabledCheckBox == null) {
            this.enabledCheckBox = new JCheckBox();
        }
        return this.enabledCheckBox;
    }

    public void clear() {
        this.address = null;
    }

    private ConfirmButtonValidatorDocListener getConfirmButtonValidatorDocListener() {
        if (this.confirmButtonValidatorDocListener == null) {
            this.confirmButtonValidatorDocListener = new ConfirmButtonValidatorDocListener();
        }
        return this.confirmButtonValidatorDocListener;
    }

    private class ConfirmButtonValidatorDocListener
    implements DocumentListener {
        private ConfirmButtonValidatorDocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkAndEnableConfirmButton();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkAndEnableConfirmButton();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkAndEnableConfirmButton();
        }

        private void checkAndEnableConfirmButton() {
            boolean bl = DialogAddPermittedAddress.this.getAddressTextField().getDocument().getLength() > 0;
            DialogAddPermittedAddress.this.setConfirmButtonEnabled(bl);
        }
    }
}

