/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.spi.multiview.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.text.Document;
import org.netbeans.api.actions.Savable;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.core.spi.multiview.text.Bundle;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

class MultiViewCloneableEditor
extends CloneableEditor
implements MultiViewElement {
    private static final long serialVersionUID = -3126744316644172415L;
    private transient MultiViewElementCallback multiViewObserver;
    private transient JPanel bar;

    public MultiViewCloneableEditor() {
    }

    public MultiViewCloneableEditor(CloneableEditorSupport cloneableEditorSupport) {
        super(cloneableEditorSupport, true);
        this.initializeBySupport();
    }

    @Override
    public JComponent getToolbarRepresentation() {
        if (this.bar == null) {
            this.bar = new JPanel();
            this.bar.setLayout(new BorderLayout());
            this.fillInBar();
        }
        return this.bar;
    }

    @Override
    public JComponent getVisualRepresentation() {
        return this;
    }

    @Override
    public final void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewObserver = multiViewElementCallback;
    }

    protected final MultiViewElementCallback getElementObserver() {
        return this.multiViewObserver;
    }

    @Override
    public void componentActivated() {
        super.componentActivated();
    }

    @Override
    public void componentClosed() {
        super.componentClosed();
    }

    @Override
    public void componentDeactivated() {
        super.componentDeactivated();
    }

    @Override
    public void componentHidden() {
        super.componentHidden();
    }

    @Override
    public void componentOpened() {
        super.componentOpened();
    }

    @Override
    public void componentShowing() {
        this.updateDisplayText();
        super.componentShowing();
    }

    @Override
    public Action[] getActions() {
        return super.getActions();
    }

    @Override
    public Lookup getLookup() {
        if (this.multiViewObserver == null) {
            return this.getLookupSuper();
        }
        return this.multiViewObserver.getTopComponent().getLookup();
    }

    public String preferredID() {
        return super.preferredID();
    }

    public void requestVisible() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    public void updateName() {
        super.updateName();
        this.updateDisplayText();
    }

    private void updateDisplayText() {
        if (this.multiViewObserver != null) {
            TopComponent topComponent = this.multiViewObserver.getTopComponent();
            topComponent.setHtmlDisplayName(this.getHtmlDisplayName());
            topComponent.setDisplayName(this.getDisplayName());
            topComponent.setName(this.getName());
            topComponent.setToolTipText(this.getToolTipText());
            topComponent.setIcon(this.getIcon());
        }
    }

    public void open() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestVisible();
        } else {
            super.open();
        }
    }

    protected boolean closeLast() {
        return true;
    }

    @Override
    public CloseOperationState canCloseElement() {
        Savable savable;
        final CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)this.getLookup().lookup(CloneableEditorSupport.class);
        Enumeration enumeration = this.getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                return CloseOperationState.STATE_OK;
            }
        }
        if ((savable = (Savable)this.getLookup().lookup(Savable.class)) != null) {
            AbstractAction abstractAction;
            block9: {
                abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            cloneableEditorSupport.saveDocument();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                };
                try {
                    if (savable.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class) {
                        abstractAction.putValue("LongDescription", Bundle.MSG_SaveModified(savable));
                    } else {
                        Logger.getLogger(MultiViewCloneableEditor.class.getName()).log(Level.WARNING, "Need to override toString() to contain the file name in o.n.api.action.Savable {0} with lookup {1}", new Object[]{savable.getClass(), this.getLookup().lookupAll(Object.class)});
                        Node node = (Node)this.getLookup().lookup(Node.class);
                        if (node != null) {
                            abstractAction.putValue("LongDescription", Bundle.MSG_SaveModified(node.getDisplayName()));
                        } else {
                            abstractAction.putValue("LongDescription", Bundle.MSG_SaveModified_no_name());
                        }
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)noSuchMethodException);
                }
            }
            return MultiViewFactory.createUnsafeCloseState("editor", abstractAction, null);
        }
        return CloseOperationState.STATE_OK;
    }

    Lookup getLookupSuper() {
        return super.getLookup();
    }

    public void revalidate() {
        super.revalidate();
        this.fillInBar();
    }

    private void fillInBar() {
        NbDocument.CustomToolbar customToolbar;
        JToolBar jToolBar;
        Document document;
        if (this.bar != null && this.bar.getComponentCount() == 0 && this.pane != null && (document = this.pane.getDocument()) instanceof NbDocument.CustomToolbar && (jToolBar = (customToolbar = (NbDocument.CustomToolbar)document).createToolbar(this.pane)) != null) {
            this.bar.add((Component)jToolBar, "Center");
        }
    }
}

