/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import org.gradle.api.Action;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.logging.text.AbstractStyledTextOutput;

public abstract class AbstractLineChoppingStyledTextOutput
extends AbstractStyledTextOutput {
    private final char[] eolChars;
    private final String eol;
    private int seenCharsFromEol;
    private State currentState = INITIAL_STATE;
    private static final State SYSTEM_EOL_PARSING_STATE;
    private static final State INITIAL_STATE;
    private static final State WELL_KNOWN_EOL_PARSING_STATE;
    private static final State WINDOWS_EOL_PARSING_ODDITY_STATE;
    private static final State START_LINE_STATE;

    protected AbstractLineChoppingStyledTextOutput() {
        this.eol = SystemProperties.getInstance().getLineSeparator();
        this.eolChars = this.eol.toCharArray();
    }

    protected final void doAppend(String text) {
        StateContext context = new StateContext(text);
        while (context.hasChar()) {
            this.currentState.execute(context);
        }
        this.seenCharsFromEol = context.seenCharsFromEol;
        context.flushLineText();
    }

    protected void doStartLine() {
    }

    protected abstract void doLineText(CharSequence var1);

    protected abstract void doEndLine(CharSequence var1);

    static {
        INITIAL_STATE = SYSTEM_EOL_PARSING_STATE = new State(){

            public void execute(StateContext context) {
                if (context.seenCharsFromEol < context.eolChars.length) {
                    if (!context.eol.equals("\r\n") && context.isCurrentCharEquals(context.eolChars[context.seenCharsFromEol])) {
                        context.seenCharsFromEol++;
                        if (context.seenCharsFromEol == context.eolChars.length) {
                            context.flushLineText();
                            context.flushEndLine(context.eol);
                            context.next(context.seenCharsFromEol);
                            context.reset();
                            context.setState(START_LINE_STATE);
                        }
                        return;
                    }
                    if (context.seenCharsFromEol == 0) {
                        WELL_KNOWN_EOL_PARSING_STATE.execute(context);
                        return;
                    }
                }
                context.next(context.seenCharsFromEol);
                context.flushLineText();
                context.reset();
                context.setState(INITIAL_STATE);
            }
        };
        WELL_KNOWN_EOL_PARSING_STATE = new State(){

            public void execute(StateContext context) {
                if (context.isCurrentCharEquals('\r')) {
                    context.seenCharsFromEol++;
                    context.setState(WINDOWS_EOL_PARSING_ODDITY_STATE);
                } else if (context.isCurrentCharEquals('\n')) {
                    context.flushLineText();
                    context.flushEndLine("\n");
                    context.next();
                    context.reset();
                    context.setState(START_LINE_STATE);
                } else {
                    context.next();
                    context.setState(INITIAL_STATE);
                }
            }
        };
        WINDOWS_EOL_PARSING_ODDITY_STATE = new State(){

            public void execute(StateContext context) {
                if (context.isCurrentCharEquals('\n')) {
                    context.flushLineText();
                    context.flushEndLine("\r\n");
                    context.next(2);
                    context.reset();
                    context.setState(START_LINE_STATE);
                } else {
                    context.seenCharsFromEol = 0;
                    context.next(2);
                    context.setState(INITIAL_STATE);
                }
            }
        };
        START_LINE_STATE = new State(){

            public void execute(StateContext context) {
                context.flushStartLine();
                context.setState(INITIAL_STATE);
            }
        };
    }

    private class StateContext {
        private final String text;
        private int pos;
        private int max;
        private int start;
        private int seenCharsFromEol;
        private final char[] eolChars;
        private final String eol;

        StateContext(String text) {
            this.seenCharsFromEol = AbstractLineChoppingStyledTextOutput.this.seenCharsFromEol;
            this.eolChars = AbstractLineChoppingStyledTextOutput.this.eolChars;
            this.eol = AbstractLineChoppingStyledTextOutput.this.eol;
            this.text = text;
            this.max = text.length();
            this.start = this.pos = -this.seenCharsFromEol;
        }

        void next() {
            ++this.pos;
        }

        void next(int count) {
            this.pos += count;
        }

        boolean isCurrentCharEquals(char value) {
            char ch = this.seenCharsFromEol + this.pos < 0 ? this.eolChars[this.pos + AbstractLineChoppingStyledTextOutput.this.seenCharsFromEol] : this.text.charAt(this.pos + this.seenCharsFromEol);
            return ch == value;
        }

        boolean hasChar() {
            return this.pos + this.seenCharsFromEol < this.max;
        }

        void setState(State state) {
            AbstractLineChoppingStyledTextOutput.this.currentState = state;
        }

        void reset() {
            this.start = this.pos;
            this.seenCharsFromEol = 0;
        }

        void flushLineText() {
            if (this.start < this.pos) {
                if (this.start < 0) {
                    AbstractLineChoppingStyledTextOutput.this.doLineText(this.eol.substring(0, AbstractLineChoppingStyledTextOutput.this.seenCharsFromEol) + this.text.substring(0, this.seenCharsFromEol - AbstractLineChoppingStyledTextOutput.this.seenCharsFromEol));
                } else {
                    AbstractLineChoppingStyledTextOutput.this.doLineText(this.text.substring(this.start, this.pos));
                }
            }
        }

        void flushEndLine(String eol) {
            AbstractLineChoppingStyledTextOutput.this.doEndLine(eol);
        }

        void flushStartLine() {
            AbstractLineChoppingStyledTextOutput.this.doStartLine();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface State
    extends Action<StateContext> {
    }
}

