/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.cache;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.ModifierFlags;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public class RecordUtil {
    private RecordUtil() {
    }

    public static boolean isDeprecatedByAnnotation(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByAnnotation"));
        }
        if (modList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modList", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByAnnotation"));
        }
        for (LighterASTNode child : tree.getChildren(modList)) {
            String name2;
            LighterASTNode id;
            LighterASTNode ref;
            if (child.getTokenType() != JavaElementType.ANNOTATION || (ref = LightTreeUtil.firstChildOfType(tree, child, JavaElementType.JAVA_CODE_REFERENCE)) == null || (id = LightTreeUtil.firstChildOfType(tree, ref, JavaTokenType.IDENTIFIER)) == null || !"Deprecated".equals(name2 = RecordUtil.intern(tree.getCharTable(), id))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeprecatedByDocComment(@NotNull LighterAST tree, @NotNull LighterASTNode comment) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByDocComment"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "isDeprecatedByDocComment"));
        }
        String text2 = LightTreeUtil.toFilteredString(tree, comment, null);
        return text2.contains("@deprecated");
    }

    public static int packModifierList(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "packModifierList"));
        }
        if (modList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modList", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "packModifierList"));
        }
        int packed = 0;
        for (LighterASTNode child : tree.getChildren(modList)) {
            packed |= ModifierFlags.KEYWORD_TO_MODIFIER_FLAG_MAP.get(child.getTokenType());
        }
        return packed;
    }

    @NotNull
    public static String intern(@NotNull CharTable table, @NotNull LighterASTNode node) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        assert (node instanceof LighterASTTokenNode) : node;
        String string = table.intern(((LighterASTTokenNode)node).getText()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "intern"));
        }
        return string;
    }

    public static boolean isStaticNonPrivateMember(@NotNull StubElement<?> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/cache/RecordUtil", "isStaticNonPrivateMember"));
        }
        StubElement<PsiModifierList> type2 = stub.findChildStubByType(JavaStubElementTypes.MODIFIER_LIST);
        if (!(type2 instanceof PsiModifierListStub)) {
            return false;
        }
        int mask = ((PsiModifierListStub)type2).getModifiersMask();
        if (ModifierFlags.hasModifierProperty("private", mask)) {
            return false;
        }
        if (ModifierFlags.hasModifierProperty("static", mask)) {
            return true;
        }
        return stub instanceof PsiFieldStub && stub.getStubType() == JavaElementType.ENUM_CONSTANT || stub.getParentStub() instanceof PsiClassStub && ((PsiClassStub)stub.getParentStub()).isInterface();
    }
}

