/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractCompositeExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;
import org.gradle.internal.component.model.IvyArtifactName;

class UnionExclusion
extends AbstractCompositeExclusion {
    private final List<AbstractModuleExclusion> filters;

    public UnionExclusion(List<AbstractModuleExclusion> filters) {
        this.filters = filters;
    }

    @Override
    Collection<AbstractModuleExclusion> getFilters() {
        return this.filters;
    }

    @Override
    protected void unpackUnion(Collection<AbstractModuleExclusion> specs) {
        specs.addAll(this.filters);
    }

    @Override
    protected boolean excludesNoModules() {
        for (AbstractModuleExclusion excludeSpec : this.filters) {
            if (!excludeSpec.excludesNoModules()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean excludeModule(ModuleIdentifier element) {
        for (AbstractModuleExclusion spec : this.filters) {
            if (spec.excludeModule(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean excludeArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        for (AbstractModuleExclusion spec : this.filters) {
            if (spec.excludeArtifact(module, artifact)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        for (AbstractModuleExclusion spec : this.filters) {
            if (spec.mayExcludeArtifacts()) continue;
            return false;
        }
        return true;
    }
}

