/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAlongAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongPanel;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DownloadAlongTrackAction
extends DownloadAlongAction {
    private static final int NEAR_TRACK = 0;
    private static final int NEAR_WAYPOINTS = 1;
    private static final int NEAR_BOTH = 2;
    private static final String PREF_DOWNLOAD_ALONG_TRACK_OSM = "downloadAlongTrack.download.osm";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_GPS = "downloadAlongTrack.download.gps";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_DISTANCE = "downloadAlongTrack.distance";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_AREA = "downloadAlongTrack.area";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_NEAR = "downloadAlongTrack.near";
    private final transient GpxData data;

    public DownloadAlongTrackAction(GpxData gpxData) {
        super(I18n.tr("Download from OSM along this track", new Object[0]), "downloadalongtrack", null, null, false);
        this.data = gpxData;
    }

    PleaseWaitRunnable createTask() {
        final DownloadAlongPanel downloadAlongPanel = new DownloadAlongPanel(PREF_DOWNLOAD_ALONG_TRACK_OSM, PREF_DOWNLOAD_ALONG_TRACK_GPS, PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, PREF_DOWNLOAD_ALONG_TRACK_AREA, PREF_DOWNLOAD_ALONG_TRACK_NEAR);
        if (0 != downloadAlongPanel.showInDownloadDialog(I18n.tr("Download from OSM along this track", new Object[0]), HelpUtil.ht("/Action/DownloadAlongTrack"))) {
            return null;
        }
        final int n = downloadAlongPanel.getNear();
        double d = 0.0;
        int n2 = 0;
        if (n == 0 || n == 2) {
            for (GpxTrack iWithAttributes : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : iWithAttributes.getSegments()) {
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        d += wayPoint.lat();
                        ++n2;
                    }
                }
            }
        }
        if (n == 1 || n == 2) {
            for (WayPoint wayPoint : this.data.waypoints) {
                d += wayPoint.getCoor().lat();
                ++n2;
            }
        }
        if (n2 == 0) {
            return null;
        }
        double d2 = d / (double)n2;
        double d3 = Math.cos(Utils.toRadians(d2));
        final double d4 = downloadAlongPanel.getDistance();
        final double d5 = downloadAlongPanel.getArea() / 10000.0 / d3;
        final double d6 = d4 / 100000.0;
        final double d7 = d6 / d3;
        final int n3 = n2;
        final boolean bl = n3 > 2000 && d6 < 0.01;
        class CalculateDownloadArea
        extends PleaseWaitRunnable {
            private final Area a;
            private boolean cancel;
            private int ticks;
            private final Rectangle2D r;

            CalculateDownloadArea() {
                super(I18n.tr("Calculating Download Area", new Object[0]), bl2 ? null : NullProgressMonitor.INSTANCE, false);
                this.a = new Area();
                this.r = new Rectangle2D.Double();
            }

            @Override
            protected void cancel() {
                this.cancel = true;
            }

            @Override
            protected void finish() {
            }

            @Override
            protected void afterFinish() {
                if (this.cancel) {
                    return;
                }
                DownloadAlongTrackAction.confirmAndDownloadAreas(this.a, d5, downloadAlongPanel.isDownloadOsmData(), downloadAlongPanel.isDownloadGpxData(), I18n.tr("Download from OSM along this track", new Object[0]), this.progressMonitor);
            }

            private void tick() {
                ++this.ticks;
                if (this.ticks % 100 == 0) {
                    this.progressMonitor.worked(100);
                }
            }

            private LatLon calcAreaForWayPoint(WayPoint wayPoint, LatLon latLon) {
                this.tick();
                LatLon latLon2 = wayPoint.getCoor();
                if (latLon == null || latLon2.greatCircleDistance(latLon) > d4) {
                    this.r.setRect(latLon2.lon() - d7, latLon2.lat() - d6, 2.0 * d7, 2.0 * d6);
                    this.a.add(new Area(this.r));
                    return latLon2;
                }
                return latLon;
            }

            @Override
            protected void realRun() {
                this.progressMonitor.setTicksCount(n3);
                LatLon latLon = null;
                if (n == 0 || n == 2) {
                    for (GpxTrack iWithAttributes : ((DownloadAlongTrackAction)DownloadAlongTrackAction.this).data.tracks) {
                        for (GpxTrackSegment gpxTrackSegment : iWithAttributes.getSegments()) {
                            for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                                if (this.cancel) {
                                    return;
                                }
                                latLon = this.calcAreaForWayPoint(wayPoint, latLon);
                            }
                        }
                    }
                }
                if (n == 1 || n == 2) {
                    for (WayPoint wayPoint : ((DownloadAlongTrackAction)DownloadAlongTrackAction.this).data.waypoints) {
                        if (this.cancel) {
                            return;
                        }
                        latLon = this.calcAreaForWayPoint(wayPoint, latLon);
                    }
                }
            }
        }
        return new CalculateDownloadArea();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PleaseWaitRunnable pleaseWaitRunnable = this.createTask();
        if (pleaseWaitRunnable != null) {
            Main.worker.submit(pleaseWaitRunnable);
        }
    }
}

