/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;

public class OSEnvironment {
    public static Map<RubyString, RubyString> environmentVariableMap(Ruby runtime) {
        Map<String, String> env = runtime.getInstanceConfig().getEnvironment();
        if (env != null) {
            return OSEnvironment.asMapOfRubyStrings(runtime, env);
        }
        if (Ruby.isSecurityRestricted()) {
            return Collections.emptyMap();
        }
        return OSEnvironment.asMapOfRubyStrings(runtime, System.getenv());
    }

    public Map<RubyString, RubyString> getEnvironmentVariableMap(Ruby runtime) {
        HashMap envMap = OSEnvironment.environmentVariableMap(runtime);
        return envMap == Collections.EMPTY_MAP ? new HashMap(4) : envMap;
    }

    public static Map<String, String> propertiesToStringMap(Properties properties) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            map2.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map2;
    }

    public static Map<RubyString, RubyString> systemPropertiesMap(Ruby runtime) {
        if (Ruby.isSecurityRestricted()) {
            return Collections.emptyMap();
        }
        return OSEnvironment.asMapOfRubyStrings(runtime, (Properties)System.getProperties().clone());
    }

    public Map<RubyString, RubyString> getSystemPropertiesMap(Ruby runtime) {
        HashMap sysMap = OSEnvironment.systemPropertiesMap(runtime);
        return sysMap == Collections.EMPTY_MAP ? new HashMap(4) : sysMap;
    }

    private static Map<RubyString, RubyString> asMapOfRubyStrings(Ruby runtime, Map<?, ?> map2) {
        HashMap<RubyString, RubyString> rubyMap = new HashMap<RubyString, RubyString>(map2.size() + 2);
        Encoding keyEncoding = runtime.getEncodingService().getLocaleEncoding();
        if (Platform.IS_WINDOWS) {
            String home2 = SafePropertyAccessor.getProperty("user.home");
            String user = SafePropertyAccessor.getProperty("user.name");
            OSEnvironment.putRubyKeyValuePair(runtime, rubyMap, "HOME", keyEncoding, home2 == null ? "/" : home2, keyEncoding);
            OSEnvironment.putRubyKeyValuePair(runtime, rubyMap, "USER", keyEncoding, user == null ? "" : user, keyEncoding);
        }
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            Object val = entry.getKey();
            if (!(val instanceof String)) continue;
            String key2 = (String)val;
            if (Platform.IS_WINDOWS && key2.startsWith("=") || !((val = entry.getValue()) instanceof String)) continue;
            Encoding valueEncoding = keyEncoding;
            if (org.jruby.platform.Platform.IS_WINDOWS ? key2.toString().equalsIgnoreCase("PATH") : key2.toString().equals("PATH")) {
                valueEncoding = runtime.getEncodingService().getFileSystemEncoding();
            }
            OSEnvironment.putRubyKeyValuePair(runtime, rubyMap, key2, keyEncoding, (String)val, valueEncoding);
        }
        return rubyMap;
    }

    private static void putRubyKeyValuePair(Ruby runtime, Map<RubyString, RubyString> map2, String key2, Encoding keyEncoding, String value2, Encoding valueEncoding) {
        ByteList keyBytes = RubyString.encodeBytelist(key2, keyEncoding);
        ByteList valueBytes = RubyString.encodeBytelist(value2, valueEncoding);
        RubyString keyString = runtime.newString(keyBytes);
        RubyString valueString = runtime.newString(valueBytes);
        keyString.setFrozen(true);
        valueString.setFrozen(true);
        map2.put(keyString, valueString);
    }
}

