/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.inline.clean.RemoveDefaultInitializersKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a*\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"getDefaultParamsNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "args", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "params", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "initialized", "", "getNameFromInitializer", "isInitializedExpr", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "isNameInitialized", "name", "initializer", "removeDefaultInitializers", "", "arguments", "parameters", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "kotlin-compiler"})
public final class RemoveDefaultInitializersKt {
    /*
     * WARNING - void declaration
     */
    public static final void removeDefaultInitializers(@NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2, @NotNull JsBlock body) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        Intrinsics.checkParameterIsNotNull(body, "body");
        Set<JsName> toRemove = RemoveDefaultInitializersKt.getDefaultParamsNames(arguments2, parameters2, true);
        Set<JsName> toExpand = RemoveDefaultInitializersKt.getDefaultParamsNames(arguments2, parameters2, false);
        List<JsStatement> statements = body.getStatements();
        Iterable iterable = $receiver$iv = (Iterable)statements;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List<JsStatement> list2;
            JsStatement it;
            JsStatement jsStatement = it = (JsStatement)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "it");
            JsName name = RemoveDefaultInitializersKt.getNameFromInitializer(jsStatement);
            if (name != null) {
                JsStatement jsStatement2 = it;
                Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "it");
                if (!RemoveDefaultInitializersKt.isNameInitialized(name, jsStatement2)) {
                    throw (Throwable)((Object)new AssertionError((Object)"Unexpected initializer structure"));
                }
            }
            if (name != null && toRemove.contains(name)) {
                list2 = CollectionsKt.emptyList();
            } else if (name != null && toExpand.contains(name)) {
                JsStatement jsStatement3 = it;
                if (jsStatement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsIf");
                }
                List<JsStatement> list3 = JsAstUtils.flattenStatement(((JsIf)jsStatement3).getThenStatement());
                list2 = list3;
                Intrinsics.checkExpressionValueIsNotNull(list3, "flattenStatement((it as JsIf).thenStatement)");
            } else {
                list2 = CollectionsKt.listOf(it);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List newStatements = (List)destination$iv$iv;
        statements.clear();
        statements.addAll(newStatements);
    }

    private static final JsName getNameFromInitializer(JsStatement statement) {
        JsStatement elseStmt;
        JsIf ifStmt;
        JsStatement jsStatement = statement;
        if (!(jsStatement instanceof JsIf)) {
            jsStatement = null;
        }
        JsIf jsIf = ifStmt = (JsIf)jsStatement;
        JsExpression testExpr = jsIf != null ? jsIf.getIfExpression() : null;
        JsIf jsIf2 = ifStmt;
        JsStatement jsStatement2 = elseStmt = jsIf2 != null ? jsIf2.getElseStatement() : null;
        if (elseStmt == null && testExpr instanceof JsBinaryOperation) {
            return RemoveDefaultInitializersKt.getNameFromInitializer((JsBinaryOperation)testExpr);
        }
        return null;
    }

    private static final JsName getNameFromInitializer(JsBinaryOperation isInitializedExpr) {
        JsExpression arg1 = isInitializedExpr.getArg1();
        JsExpression arg2 = isInitializedExpr.getArg2();
        JsBinaryOperator op = isInitializedExpr.getOperator();
        if (arg1 == null || arg2 == null) {
            return null;
        }
        if (Intrinsics.areEqual(op, JsBinaryOperator.REF_EQ) && JsAstUtils.isUndefinedExpression(arg2)) {
            JsExpression jsExpression = arg1;
            if (!(jsExpression instanceof JsNameRef)) {
                jsExpression = null;
            }
            JsNameRef jsNameRef = (JsNameRef)jsExpression;
            return jsNameRef != null ? jsNameRef.getName() : null;
        }
        return null;
    }

    private static final boolean isNameInitialized(JsName name, JsStatement initializer2) {
        JsExpression expr;
        JsStatement jsStatement = initializer2;
        if (jsStatement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsIf");
        }
        JsStatement thenStmt = ((JsIf)jsStatement).getThenStatement();
        JsStatement lastThenStmt = CollectionsKt.last(JsAstUtils.flattenStatement(thenStmt));
        JsStatement jsStatement2 = lastThenStmt;
        if (!(jsStatement2 instanceof JsExpressionStatement)) {
            jsStatement2 = null;
        }
        JsExpressionStatement jsExpressionStatement = (JsExpressionStatement)jsStatement2;
        JsExpression jsExpression = expr = jsExpressionStatement != null ? jsExpressionStatement.getExpression() : null;
        if (!(expr instanceof JsBinaryOperation)) {
            return false;
        }
        JsBinaryOperator op = ((JsBinaryOperation)expr).getOperator();
        if (!op.isAssignment()) {
            return false;
        }
        JsExpression arg1 = ((JsBinaryOperation)expr).getArg1();
        return arg1 instanceof HasName && ((HasName)((Object)arg1)).getName() == name;
    }

    private static final Set<JsName> getDefaultParamsNames(List<? extends JsExpression> args, List<JsParameter> params, boolean initialized) {
        List argsParams = CollectionUtilsKt.zipWithDefault((Iterable)args, (Iterable)params, Namer.getUndefinedExpression());
        Sequence relevantParams2 = SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence(argsParams), getDefaultParamsNames.relevantParams.1.INSTANCE), (Function1)new Function1<Pair<? extends JsExpression, ? extends JsParameter>, Boolean>(initialized){
            final /* synthetic */ boolean $initialized;

            public final boolean invoke(@NotNull Pair<? extends JsExpression, JsParameter> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return this.$initialized == !JsAstUtils.isUndefinedExpression(it.getFirst());
            }
            {
                this.$initialized = bl;
                super(1);
            }
        });
        Sequence names2 = SequencesKt.map(relevantParams2, getDefaultParamsNames.names.1.INSTANCE);
        return CollectionUtilsKt.toIdentitySet(names2);
    }
}

