/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttrColor;
import org.eclipse.swt.internal.gtk.PangoAttrInt;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    boolean inComposition;

    IME() {
    }

    public IME(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] nArray = new int[this.ranges.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.ranges[i] + this.startOffset;
        }
        return nArray;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, textStyleArray, 0, this.styles.length);
        return textStyleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        return false;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        if (!this.isInlineEnabled()) {
            return 0L;
        }
        long l3 = this.imHandle();
        if (l3 != 0L) {
            OS.gtk_im_context_reset(l3);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long l, long l2) {
        int n;
        if (!this.isInlineEnabled()) {
            return 0L;
        }
        boolean bl = true;
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        if (l2 != 0L && this.inComposition && (n = OS.strlen(l2)) != 0) {
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l2, (long)n);
            char[] cArray = Converter.mbcsToWcs(null, byArray);
            Event event = new Event();
            event.detail = 1;
            event.start = this.startOffset;
            event.end = this.startOffset + this.text.length();
            this.text = cArray != null ? new String(cArray) : "";
            event.text = this.text;
            this.commitCount = this.text.length();
            this.sendEvent(43, event);
            bl = event.doit;
            this.text = "";
            this.startOffset = -1;
            this.commitCount = 0;
        }
        this.inComposition = false;
        return bl ? 0L : 1L;
    }

    @Override
    long gtk_preedit_changed(long l) {
        Object object;
        int n;
        if (!this.isInlineEnabled()) {
            return 0L;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        long l2 = this.imHandle();
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        int[] nArray = new int[1];
        OS.gtk_im_context_get_preedit_string(l2, lArray, lArray2, nArray);
        this.caretOffset = nArray[0];
        char[] cArray = null;
        if (lArray[0] != 0L) {
            n = OS.strlen(lArray[0]);
            object = new byte[n];
            OS.memmove(object, lArray[0], (long)n);
            cArray = Converter.mbcsToWcs(null, object);
            if (lArray2[0] != 0L) {
                int n2 = 0;
                long l3 = OS.pango_attr_list_get_iterator(lArray2[0]);
                while (OS.pango_attr_iterator_next(l3)) {
                    ++n2;
                }
                OS.pango_attr_iterator_destroy(l3);
                this.ranges = new int[n2 * 2];
                this.styles = new TextStyle[n2];
                l3 = OS.pango_attr_list_get_iterator(lArray2[0]);
                PangoAttrColor pangoAttrColor = new PangoAttrColor();
                PangoAttrInt pangoAttrInt = new PangoAttrInt();
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                for (int i = 0; i < n2; ++i) {
                    GdkColor gdkColor;
                    OS.pango_attr_iterator_range(l3, nArray2, nArray3);
                    this.ranges[i * 2] = (int)OS.g_utf16_pointer_to_offset(lArray[0], lArray[0] + (long)nArray2[0]);
                    this.ranges[i * 2 + 1] = (int)OS.g_utf16_pointer_to_offset(lArray[0], lArray[0] + (long)nArray3[0]) - 1;
                    this.styles[i] = new TextStyle(null, null, null);
                    long l4 = OS.pango_attr_iterator_get(l3, 9);
                    if (l4 != 0L) {
                        OS.memmove(pangoAttrColor, l4, (long)PangoAttrColor.sizeof);
                        gdkColor = new GdkColor();
                        gdkColor.red = pangoAttrColor.color_red;
                        gdkColor.green = pangoAttrColor.color_green;
                        gdkColor.blue = pangoAttrColor.color_blue;
                        this.styles[i].foreground = Color.gtk_new(this.display, gdkColor);
                    }
                    if ((l4 = OS.pango_attr_iterator_get(l3, 10)) != 0L) {
                        OS.memmove(pangoAttrColor, l4, (long)PangoAttrColor.sizeof);
                        gdkColor = new GdkColor();
                        gdkColor.red = pangoAttrColor.color_red;
                        gdkColor.green = pangoAttrColor.color_green;
                        gdkColor.blue = pangoAttrColor.color_blue;
                        this.styles[i].background = Color.gtk_new(this.display, gdkColor);
                    }
                    if ((l4 = OS.pango_attr_iterator_get(l3, 11)) != 0L) {
                        OS.memmove(pangoAttrInt, l4, (long)PangoAttrInt.sizeof);
                        this.styles[i].underline = pangoAttrInt.value != 0;
                        this.styles[i].underlineStyle = 0;
                        switch (pangoAttrInt.value) {
                            case 2: {
                                this.styles[i].underlineStyle = 1;
                                break;
                            }
                            case 4: {
                                this.styles[i].underlineStyle = 2;
                            }
                        }
                        if (this.styles[i].underline && (l4 = OS.pango_attr_iterator_get(l3, 18)) != 0L) {
                            OS.memmove(pangoAttrColor, l4, (long)PangoAttrColor.sizeof);
                            gdkColor = new GdkColor();
                            gdkColor.red = pangoAttrColor.color_red;
                            gdkColor.green = pangoAttrColor.color_green;
                            gdkColor.blue = pangoAttrColor.color_blue;
                            this.styles[i].underlineColor = Color.gtk_new(this.display, gdkColor);
                        }
                    }
                    OS.pango_attr_iterator_next(l3);
                }
                OS.pango_attr_iterator_destroy(l3);
                OS.pango_attr_list_unref(lArray2[0]);
            }
            OS.g_free(lArray[0]);
        }
        if (cArray != null) {
            if (this.text.length() == 0) {
                if (cArray.length == 0) {
                    return 0L;
                }
                this.startOffset = -1;
            }
            n = this.startOffset + this.text.length();
            if (this.startOffset == -1) {
                object = new Event();
                object.detail = 3;
                this.sendEvent(43, (Event)object);
                this.startOffset = object.start;
                n = object.end;
            }
            this.inComposition = true;
            object = new Event();
            object.detail = 1;
            object.start = this.startOffset;
            object.end = n;
            this.text = cArray != null ? new String(cArray) : "";
            object.text = this.text;
            this.sendEvent(43, (Event)object);
        }
        return 1L;
    }

    long imHandle() {
        return this.parent.imHandle();
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = n;
        }
    }
}

