/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.system;

import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Date;
import bt747.sys.interfaces.BT747File;
import bt747.sys.interfaces.BT747HashSet;
import bt747.sys.interfaces.BT747Hashtable;
import bt747.sys.interfaces.BT747HttpSender;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747RAFile;
import bt747.sys.interfaces.BT747Semaphore;
import bt747.sys.interfaces.BT747StringTokenizer;
import bt747.sys.interfaces.BT747Thread;
import bt747.sys.interfaces.BT747Time;
import bt747.sys.interfaces.BT747Vector;
import bt747.sys.interfaces.JavaLibImplementation;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Locale;
import net.sf.bt747.j2se.system.J2SEDate;
import net.sf.bt747.j2se.system.J2SEGeneric;
import net.sf.bt747.j2se.system.J2SEHashSet;
import net.sf.bt747.j2se.system.J2SEHashtable;
import net.sf.bt747.j2se.system.J2SEHttpSenderImpl;
import net.sf.bt747.j2se.system.J2SERAFile;
import net.sf.bt747.j2se.system.J2SESemaphore;
import net.sf.bt747.j2se.system.J2SEStringTokenizer;
import net.sf.bt747.j2se.system.J2SETime;
import net.sf.bt747.j2se.system.J2SEVector;
import net.sf.bt747.j2se.system.NRCDecoder;

public final class J2SEJavaTranslations
implements JavaLibImplementation {
    private static J2SEJavaTranslations singleton;
    private static final DecimalFormat[] nf;
    private static final long appStartTime;
    private static String appSettings;
    private BT747HttpSender httpSenderInstance = null;

    private J2SEJavaTranslations() {
    }

    public static final J2SEJavaTranslations getInstance() {
        if (singleton == null) {
            singleton = new J2SEJavaTranslations();
        }
        return singleton;
    }

    public final BT747Date getDateInstance() {
        return new J2SEDate();
    }

    public final BT747Date getDateInstance(int n, int n2, int n3) {
        return new J2SEDate(n, n2, n3);
    }

    public final BT747Date getDateInstance(String string, byte by) {
        return new J2SEDate(string, by);
    }

    public final BT747Hashtable getHashtableInstance(int n) {
        return new J2SEHashtable(n);
    }

    public final BT747Vector getVectorInstance() {
        return new J2SEVector();
    }

    public final BT747Time getTimeInstance() {
        return new J2SETime();
    }

    public final BT747RAFile getRAFileInstance(BT747Path bT747Path) {
        return new J2SERAFile(bT747Path.getPath());
    }

    public final BT747RAFile getRAFileInstance(BT747Path bT747Path, int n) {
        return new J2SERAFile(bT747Path.getPath(), n);
    }

    public final BT747File getFileInstance(BT747Path bT747Path) {
        return new J2SERAFile(bT747Path.getPath());
    }

    public final BT747File getFileInstance(BT747Path bT747Path, int n) {
        return this.getRAFileInstance(bT747Path, n);
    }

    public final boolean isAvailable() {
        return true;
    }

    public final void debug(String string, Throwable throwable) {
        J2SEGeneric.debug(string, throwable);
    }

    public final double pow(double d, double d2) {
        return Math.pow(d, d2);
    }

    public final double acos(double d) {
        return Math.acos(d);
    }

    public final void addThread(BT747Thread bT747Thread, boolean bl) {
        J2SEGeneric.addThread(bT747Thread, bl);
    }

    public final void removeThread(BT747Thread bT747Thread) {
        J2SEGeneric.removeThread(bT747Thread);
    }

    public final String toString(boolean bl) {
        return String.valueOf(bl);
    }

    public final String toString(float f) {
        return Float.toString(f);
    }

    public final String toString(double d) {
        return Double.toString(d);
    }

    public final synchronized String toString(double d, int n) {
        return nf[n].format(d);
    }

    public final String unsigned2hex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == n2) {
            return string;
        }
        if (string.length() < n2) {
            return "0000000000000000".substring(16 - n2 + string.length()).concat(string);
        }
        return string.substring(string.length() - n2);
    }

    public final int toInt(String string) {
        return Integer.valueOf(string);
    }

    public final float toFloat(String string) {
        return Float.parseFloat(string);
    }

    public final double toDouble(String string) {
        return Double.parseDouble(string);
    }

    public final double longBitsToDouble(long l) {
        return Double.longBitsToDouble(l);
    }

    public final float toFloatBitwise(int n) {
        return Float.intBitsToFloat(n);
    }

    public final int toIntBitwise(float f) {
        return Float.floatToIntBits(f);
    }

    public final void debug(String string) {
        this.debug(string, null);
    }

    public final int getTimeStamp() {
        return (int)(System.currentTimeMillis() - appStartTime);
    }

    public final String getAppSettings() {
        return appSettings;
    }

    public final void setAppSettings(String string) {
        appSettings = string;
    }

    public final BT747Semaphore getSemaphoreInstance(int n) {
        return new J2SESemaphore(n);
    }

    public final BT747StringTokenizer getStringTokenizer(String string, char c) {
        return new J2SEStringTokenizer(string, c);
    }

    public final BT747HashSet getHashSetInstance() {
        return new J2SEHashSet();
    }

    public final BT747HttpSender getHttpSenderInstance() {
        if (this.httpSenderInstance == null) {
            this.httpSenderInstance = new J2SEHttpSenderImpl();
        }
        return this.httpSenderInstance;
    }

    public final double atan(double d) {
        return Math.atan(d);
    }

    public final double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public final String convertHTMLtoUTF8(String string) {
        return NRCDecoder.decode(string);
    }

    public final byte[] getUTF8Bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Generic.debug("Issue converting string to UTF8", unsupportedEncodingException);
            return new byte[0];
        }
    }

    static {
        nf = new DecimalFormat[17];
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        int n = 0;
        while (true) {
            if (n >= 17) break;
            J2SEJavaTranslations.nf[n] = new DecimalFormat("#######0.0000000000000000".substring(0, n + 9));
            nf[n].setGroupingUsed(false);
            ++n;
        }
        Locale.setDefault(locale);
        appStartTime = System.currentTimeMillis();
        appSettings = "";
    }
}

