/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.ReturnControl;
import org.gjt.sp.jedit.bsh.SimpleNode;

class BSHIfStatement
extends SimpleNode {
    BSHIfStatement(int n) {
        super(n);
    }

    @Override
    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        Object object = null;
        if (BSHIfStatement.evaluateCondition((SimpleNode)this.jjtGetChild(0), callStack, interpreter)) {
            object = ((SimpleNode)this.jjtGetChild(1)).eval(callStack, interpreter);
        } else if (this.jjtGetNumChildren() > 2) {
            object = ((SimpleNode)this.jjtGetChild(2)).eval(callStack, interpreter);
        }
        if (object instanceof ReturnControl) {
            return object;
        }
        return Primitive.VOID;
    }

    public static boolean evaluateCondition(SimpleNode simpleNode, CallStack callStack, Interpreter interpreter) throws EvalError {
        Object object = simpleNode.eval(callStack, interpreter);
        if (object instanceof Primitive) {
            if (object == Primitive.VOID) {
                throw new EvalError("Condition evaluates to void type", simpleNode, callStack);
            }
            object = ((Primitive)object).getValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new EvalError("Condition must evaluate to a Boolean or boolean.", simpleNode, callStack);
    }
}

