/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.FixStackWithLabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantCheckCastEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantGotoMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantCoercionToUnitTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckV2MethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class OptimizationMethodVisitor
extends TransformationMethodVisitor {
    private static final MethodTransformer MANDATORY_METHOD_TRANSFORMER = new FixStackWithLabelNormalizationMethodTransformer();
    private static final MethodTransformer[] OPTIMIZATION_TRANSFORMERS = new MethodTransformer[]{new RedundantNullCheckV2MethodTransformer(), new RedundantCheckCastEliminationMethodTransformer(), new RedundantBoxingMethodTransformer(), new RedundantCoercionToUnitTransformer(), new DeadCodeEliminationMethodTransformer(), new RedundantGotoMethodTransformer(), new RedundantNopsCleanupMethodTransformer()};
    private final boolean disableOptimization;

    public OptimizationMethodVisitor(@NotNull MethodVisitor delegate2, boolean disableOptimization, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (delegate2 == null) {
            OptimizationMethodVisitor.$$$reportNull$$$0(0);
        }
        if (name == null) {
            OptimizationMethodVisitor.$$$reportNull$$$0(1);
        }
        if (desc == null) {
            OptimizationMethodVisitor.$$$reportNull$$$0(2);
        }
        super(delegate2, access, name, desc, signature, exceptions);
        this.disableOptimization = disableOptimization;
    }

    @Override
    protected void performTransformations(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            OptimizationMethodVisitor.$$$reportNull$$$0(3);
        }
        MANDATORY_METHOD_TRANSFORMER.transform("fake", methodNode);
        if (OptimizationMethodVisitor.canBeOptimized(methodNode) && !this.disableOptimization) {
            for (MethodTransformer transformer : OPTIMIZATION_TRANSFORMERS) {
                transformer.transform("fake", methodNode);
            }
        }
        UtilKt.prepareForEmitting(methodNode);
    }

    private static boolean canBeOptimized(@NotNull MethodNode node) {
        int totalFramesSizeMb;
        if (node == null) {
            OptimizationMethodVisitor.$$$reportNull$$$0(4);
        }
        return (totalFramesSizeMb = node.instructions.size() * (node.maxLocals + node.maxStack) / 0x100000) < 50;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performTransformations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeOptimized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

