#ifndef _EFL_UI_PROGRESS_EO_H_
#define _EFL_UI_PROGRESS_EO_H_

#ifndef _EFL_UI_PROGRESS_EO_CLASS_TYPE
#define _EFL_UI_PROGRESS_EO_CLASS_TYPE

typedef Eo Efl_Ui_Progress;

#endif

#ifndef _EFL_UI_PROGRESS_EO_TYPES
#define _EFL_UI_PROGRESS_EO_TYPES


#endif
#define EFL_UI_PROGRESS_INTERFACE efl_ui_progress_interface_get()

EWAPI const Eo_Class *efl_ui_progress_interface_get(void);

/**
 * @brief Control the (exact) length of the bar region of a given progress
 * widget
 *
 * This sets the minimum width (when in horizontal mode) or height (when in
 * vertical mode) of the actual bar area of the progress bar @c obj. This in
 * turn affects the object's minimum size. Use this when you're not setting
 * other size hints expanding on the given direction (like weight and alignment
 * hints) and you would like it to have a specific size.
 *
 * @note Icon, label and unit text around @c obj will require their own space,
 * which will make @c obj to require more the @c size, actually.
 *
 * @return The length of the progress's bar region
 *
 * @ingroup Efl_Ui_Progress
 */
EOAPI int efl_ui_progress_span_size_get(const Eo *obj);

/**
 * @brief Control the (exact) length of the bar region of a given progress
 * widget
 *
 * This sets the minimum width (when in horizontal mode) or height (when in
 * vertical mode) of the actual bar area of the progress bar @c obj. This in
 * turn affects the object's minimum size. Use this when you're not setting
 * other size hints expanding on the given direction (like weight and alignment
 * hints) and you would like it to have a specific size.
 *
 * @note Icon, label and unit text around @c obj will require their own space,
 * which will make @c obj to require more the @c size, actually.
 *
 * @param[in] size The length of the progress's bar region
 *
 * @ingroup Efl_Ui_Progress
 */
EOAPI void efl_ui_progress_span_size_set(Eo *obj, int size);

/**
 * @brief Control the progress value (in percentage) on a given progress widget
 *
 * Use this call to set progress levels.
 *
 * @note If you pass a value out of the specified range for @c val, it will be
 * interpreted as the closest of the boundary values in the range.
 *
 * @return The progress value (must be between $0.0 and 1.0)
 *
 * @ingroup Efl_Ui_Progress
 */
EOAPI double efl_ui_progress_value_get(const Eo *obj);

/**
 * @brief Control the progress value (in percentage) on a given progress widget
 *
 * Use this call to set progress levels.
 *
 * @note If you pass a value out of the specified range for @c val, it will be
 * interpreted as the closest of the boundary values in the range.
 *
 * @param[in] val The progress value (must be between $0.0 and 1.0)
 *
 * @ingroup Efl_Ui_Progress
 */
EOAPI void efl_ui_progress_value_set(Eo *obj, double val);

/**
 * @brief Control the format string for a given progress widget's units label
 *
 * If @c NULL is passed on @c format, it will make @c obj's units area to be
 * hidden completely. If not, it'll set the <b>format string</b> for the units
 * label's text. The units label is provided a floating point value, so the
 * units text is up display at most one floating point value. Note that the
 * units label is optional. Use a format string such as "%1.2f meters" for
 * example.
 *
 * @note The default format string for a progress is an integer percentage, as
 * in $"%.0f %%".
 *
 * @return The format string for @c obj's units label
 *
 * @ingroup Efl_Ui_Progress
 */
EOAPI const char *efl_ui_progress_unit_format_get(const Eo *obj);

/**
 * @brief Control the format string for a given progress widget's units label
 *
 * If @c NULL is passed on @c format, it will make @c obj's units area to be
 * hidden completely. If not, it'll set the <b>format string</b> for the units
 * label's text. The units label is provided a floating point value, so the
 * units text is up display at most one floating point value. Note that the
 * units label is optional. Use a format string such as "%1.2f meters" for
 * example.
 *
 * @note The default format string for a progress is an integer percentage, as
 * in $"%.0f %%".
 *
 * @param[in] units The format string for @c obj's units label
 *
 * @ingroup Efl_Ui_Progress
 */
EOAPI void efl_ui_progress_unit_format_set(Eo *obj, const char *units);


#endif
