/**
 * \file adec-types.h
 * \brief  Definitiond Of Audio Dec Types
 * \version 1.0.0
 * \date 2011-03-08
 */
/* Copyright (C) 2007-2011, Amlogic Inc.
 * All right reserved
 *
 */
#ifndef ADEC_TYPES_H
#define ADEC_TYPES_H

typedef enum {
	ADEC_AUDIO_FORMAT_UNKNOWN = 0,
	ADEC_AUDIO_FORMAT_MPEG,
	ADEC_AUDIO_FORMAT_PCM_S16LE,
	ADEC_AUDIO_FORMAT_AAC,
	ADEC_AUDIO_FORMAT_AC3,
	ADEC_AUDIO_FORMAT_ALAW,
	ADEC_AUDIO_FORMAT_MULAW,
	ADEC_AUDIO_FORMAT_DTS,
	ADEC_AUDIO_FORMAT_PCM_S16BE,
	ADEC_AUDIO_FORMAT_FLAC,
	ADEC_AUDIO_FORMAT_COOK,
	ADEC_AUDIO_FORMAT_PCM_U8,
	ADEC_AUDIO_FORMAT_ADPCM,
	ADEC_AUDIO_FORMAT_AMR,
	ADEC_AUDIO_FORMAT_RAAC,
	ADEC_AUDIO_FORMAT_WMA,
	ADEC_AUDIO_FORMAT_WMAPRO,
	ADEC_AUDIO_AFORMAT_PCM_BLURAY,
	ADEC_AUDIO_AFORMAT_ALAC,
	ADEC_AUDIO_AFORMAT_VORBIS,
	ADEC_AUDIO_FORMAT_AAC_LATM,
    ADEC_AUDIO_FORMAT_APE,
	ADEC_AUDIO_FORMAT_EAC3,
	ADEC_AUDIO_FORMAT_PCM_WIFIDISPLAY,
	ADEC_AUDIO_FORMAT_MAX,
} adec_audio_format_t;

#define VALID_FMT(f)    ((f>ADEC_AUDIO_FORMAT_UNKNOWN)&& (f<ADEC_AUDIO_FORMAT_MAX))

typedef enum {
    IDLE,
    TERMINATED,
    STOPPED,
    INITING,
    INITTED,
    ACTIVE,
    PAUSED,
} adec_state_t;

#endif
