/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report;

import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Toolkit;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.ReportExecutionException;

public class SOImageService
implements ImageService {
    private final XGraphicProvider m_xGraphicProvider;

    public SOImageService(XComponentContext xCompContext) throws ReportExecutionException, com.sun.star.uno.Exception {
        if (xCompContext == null) {
            throw new ReportExecutionException("SOImageService constructed with null Component Context");
        }
        XMultiComponentFactory xMCF = xCompContext.getServiceManager();
        this.m_xGraphicProvider = (XGraphicProvider)UnoRuntime.queryInterface(XGraphicProvider.class, (Object)xMCF.createInstanceWithContext("com.sun.star.graphic.GraphicProvider", xCompContext));
        if (this.m_xGraphicProvider == null) {
            throw new ReportExecutionException("There is no graphic-provider available for SOImageService.");
        }
    }

    private Size getImageSize(XInputStream image) throws ReportExecutionException {
        Size dim = new Size();
        try {
            PropertyValue[] value = new PropertyValue[]{new PropertyValue()};
            value[0].Name = "InputStream";
            value[0].Value = image;
            XPropertySet xImage = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xGraphicProvider.queryGraphic(value));
            if (xImage != null) {
                XPropertySetInfo xInfo = xImage.getPropertySetInfo();
                if (xInfo.hasPropertyByName("Size100thMM")) {
                    Size imageSize = (Size)xImage.getPropertyValue("Size100thMM");
                    dim.Width = imageSize.Width;
                    dim.Height = imageSize.Height;
                    if (dim.Height == 0 && dim.Width == 0) {
                        imageSize = (Size)xImage.getPropertyValue("SizePixel");
                        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
                        double fac = 2540.0 / (double)dpi;
                        dim.Width = (int)((double)imageSize.Width * fac);
                        dim.Height = (int)((double)imageSize.Height * fac);
                    }
                } else if (xInfo.hasPropertyByName("SizePixel")) {
                    Size imageSize = (Size)xImage.getPropertyValue("SizePixel");
                    int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
                    double fac = 2540.0 / (double)dpi;
                    dim.Width = (int)((double)imageSize.Width * fac);
                    dim.Height = (int)((double)imageSize.Height * fac);
                }
            }
        }
        catch (Exception ex) {
            throw new ReportExecutionException("Failed to query Image-Size", ex);
        }
        return dim;
    }

    public Size getImageSize(byte[] image) throws ReportExecutionException {
        return this.getImageSize((XInputStream)new ByteArrayToXInputStreamAdapter(image));
    }

    private String getMimeType(XInputStream image) throws ReportExecutionException {
        try {
            XPropertySetInfo xInfo;
            PropertyValue[] value = new PropertyValue[]{new PropertyValue()};
            value[0].Name = "InputStream";
            value[0].Value = image;
            XPropertySet xImage = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xGraphicProvider.queryGraphic(value));
            if (xImage != null && (xInfo = xImage.getPropertySetInfo()).hasPropertyByName("MimeType")) {
                return (String)xImage.getPropertyValue("MimeType");
            }
        }
        catch (UnknownPropertyException ex) {
            throw new ReportExecutionException(ex);
        }
        catch (WrappedTargetException ex) {
            throw new ReportExecutionException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ReportExecutionException(ex);
        }
        catch (IOException ex) {
            throw new ReportExecutionException(ex);
        }
        return null;
    }

    public String getMimeType(byte[] image) throws ReportExecutionException {
        return this.getMimeType((XInputStream)new ByteArrayToXInputStreamAdapter(image));
    }
}

