/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty.internal;

import java.io.File;
import java.util.List;
import org.gradle.api.plugins.jetty.internal.JettyConfiguration;
import org.mortbay.jetty.plus.webapp.EnvConfiguration;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.JettyWebXmlConfiguration;
import org.mortbay.jetty.webapp.TagLibConfiguration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebInfConfiguration;

public class JettyPluginWebAppContext
extends WebAppContext {
    private List<File> classpathFiles;
    private File jettyEnvXmlFile;
    private File webXmlFile;
    private WebInfConfiguration webInfConfig = new WebInfConfiguration();
    private EnvConfiguration envConfig = new EnvConfiguration();
    private JettyConfiguration mvnConfig = new JettyConfiguration();
    private JettyWebXmlConfiguration jettyWebConfig = new JettyWebXmlConfiguration();
    private TagLibConfiguration tagConfig = new TagLibConfiguration();
    private Configuration[] configs = new Configuration[]{this.webInfConfig, this.envConfig, this.mvnConfig, this.jettyWebConfig, this.tagConfig};

    public JettyPluginWebAppContext() {
        this.setConfigurations(this.configs);
    }

    public void setClassPathFiles(List<File> classpathFiles) {
        this.classpathFiles = classpathFiles;
    }

    public List<File> getClassPathFiles() {
        return this.classpathFiles;
    }

    public void setWebXmlFile(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public void setJettyEnvXmlFile(File jettyEnvXmlFile) {
        this.jettyEnvXmlFile = jettyEnvXmlFile;
    }

    public File getJettyEnvXmlFile() {
        return this.jettyEnvXmlFile;
    }

    public void configure() {
        this.setConfigurations(this.configs);
        this.mvnConfig.setClassPathConfiguration(this.classpathFiles);
        this.mvnConfig.setWebXml(this.webXmlFile);
        try {
            if (this.jettyEnvXmlFile != null) {
                this.envConfig.setJettyEnvXml(this.jettyEnvXmlFile.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doStart() throws Exception {
        this.setShutdown(false);
        super.doStart();
    }

    public void doStop() throws Exception {
        this.setShutdown(true);
        Thread.sleep(500L);
        super.doStop();
    }
}

