/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.repository.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.BuildAdapter;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.event.ListenerManager;
import org.gradle.plugin.repository.PluginRepository;
import org.gradle.plugin.repository.internal.PluginRepositoryInternal;
import org.gradle.plugin.repository.internal.PluginRepositoryRegistry;

public class DefaultPluginRepositoryRegistry
implements PluginRepositoryRegistry {
    private final List<PluginRepositoryInternal> repositories = Lists.newArrayList();
    private boolean locked;

    public DefaultPluginRepositoryRegistry(ListenerManager listenerManager) {
        listenerManager.addListener((Object)new BuildAdapter(){

            public void projectsLoaded(Gradle gradle) {
                DefaultPluginRepositoryRegistry.this.lock();
            }
        });
    }

    public void add(PluginRepository pluginRepository) {
        if (this.locked) {
            throw new IllegalStateException("Cannot add a PluginRepository after projects have been loaded.");
        }
        this.repositories.add((PluginRepositoryInternal)pluginRepository);
    }

    private void lock() {
        this.locked = true;
        for (PluginRepositoryInternal repository : this.repositories) {
            repository.lock("Projects have already been loaded.");
        }
    }

    public ImmutableList<PluginRepositoryInternal> getPluginRepositories() {
        return ImmutableList.copyOf(this.repositories);
    }
}

