/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.IOException;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.AbstractRoleAwareBuildCacheServiceDecorator;
import org.gradle.caching.internal.RoleAwareBuildCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBuildCacheServiceDecorator
extends AbstractRoleAwareBuildCacheServiceDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingBuildCacheServiceDecorator.class);

    public LoggingBuildCacheServiceDecorator(RoleAwareBuildCacheService delegate) {
        super(delegate);
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        try {
            LOGGER.debug("Loading entry {} from {} build cache", (Object)key, (Object)this.getRole());
            return super.load(key, reader);
        }
        catch (BuildCacheException e) {
            LOGGER.warn("Could not load entry {} from {} build cache", new Object[]{key, this.getRole(), e});
            throw e;
        }
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) throws BuildCacheException {
        try {
            LOGGER.debug("Storing entry {} in {} build cache", (Object)key, (Object)this.getRole());
            super.store(key, writer);
        }
        catch (BuildCacheException e) {
            LOGGER.warn("Could not store entry {} in {} build cache", new Object[]{key, this.getRole(), e});
            throw e;
        }
    }

    public void close() throws IOException {
        LOGGER.debug("Closing {} build cache", (Object)this.getRole());
        super.close();
    }
}

