/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.parse;

import java.util.Iterator;
import org.simpleframework.http.Cookie;
import org.simpleframework.util.parse.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieParser
extends Parser
implements Iterable<Cookie> {
    private boolean finished = true;
    private boolean parsed;
    private int version;
    private Token name;
    private Token value;
    private Token path = new Token();
    private Token domain = new Token();

    public CookieParser() {
        this.name = new Token();
        this.value = new Token();
    }

    public CookieParser(String header) {
        this();
        this.parse(header);
    }

    @Override
    protected void init() {
        this.finished = false;
        this.parsed = false;
        this.version = 0;
        this.off = 0;
        this.version();
    }

    @Override
    protected void parse() {
        if (!this.finished) {
            this.cookie();
            this.parsed = true;
        }
    }

    @Override
    protected boolean skip(String text) {
        int size = text.length();
        int seek = this.off;
        int read = 0;
        if (this.off + size > this.count) {
            return false;
        }
        while (read < size) {
            char a = text.charAt(read);
            char b = this.buf[seek];
            if (this.space(b)) {
                if (++seek < this.count) continue;
                return false;
            }
            if (this.space(a)) {
                if (++read < size) continue;
                continue;
            }
            if (this.toLower(a) != this.toLower(b)) {
                return false;
            }
            ++read;
            ++seek;
        }
        this.off = seek;
        while (this.off < this.count && this.space(this.buf[this.off])) {
            ++this.off;
        }
        return true;
    }

    @Override
    public Iterator<Cookie> iterator() {
        return new Sequence();
    }

    public void reset() {
        this.init();
        this.parse();
    }

    private Cookie getCookie() {
        return this.getCookie(this.name.toString(), this.value.toString());
    }

    private Cookie getCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value, false);
        if (this.domain.len > 0) {
            cookie.setDomain(this.domain.toString());
        }
        if (this.path.len > 0) {
            cookie.setPath(this.path.toString());
        }
        cookie.setVersion(this.version);
        return cookie;
    }

    private void cookie() {
        if (!this.skip(",")) {
            this.skip(";");
        }
        this.name();
        this.skip("=");
        this.value();
    }

    private void name() {
        this.name.off = this.off;
        this.name.len = 0;
        while (this.off < this.count && this.buf[this.off] != '=') {
            ++this.name.len;
            ++this.off;
        }
    }

    private void value() {
        this.data();
        this.path();
        this.domain();
    }

    private void data() {
        this.value.off = this.off;
        this.value.len = 0;
        if (this.off < this.count && this.buf[this.off] == '\"') {
            ++this.value.len;
            ++this.off;
            while (this.off < this.count) {
                ++this.value.len;
                if (this.buf[this.off++] != '\"' || this.buf[this.off - 2] == '\\') continue;
            }
            this.value.len -= 2;
            ++this.value.off;
        } else {
            while (this.off < this.count && !this.terminal(this.buf[this.off])) {
                ++this.value.len;
                ++this.off;
            }
        }
    }

    private void path() {
        this.path.len = 0;
        if (this.skip(";$Path=")) {
            this.path.off = this.off;
            if (this.buf[this.off] == '\"') {
                ++this.path.len;
                ++this.off;
                while (this.off < this.count) {
                    ++this.path.len;
                    if (this.buf[this.off++] != '\"' || this.buf[this.off - 2] == '\\') continue;
                }
                this.path.len -= 2;
                ++this.path.off;
            } else {
                while (this.off < this.count && !this.terminal(this.buf[this.off])) {
                    ++this.path.len;
                    ++this.off;
                }
            }
        }
    }

    private void domain() {
        this.domain.len = 0;
        if (this.skip(";$Domain=")) {
            this.domain.off = this.off;
            if (this.buf[this.off] == '\"') {
                ++this.domain.len;
                ++this.off;
                while (this.off < this.count) {
                    ++this.domain.len;
                    if (this.buf[this.off++] != '\"' || this.buf[this.off - 2] == '\\') continue;
                }
                this.domain.len -= 2;
                ++this.domain.off;
            } else {
                while (this.off < this.count && !this.terminal(this.buf[this.off])) {
                    ++this.domain.len;
                    ++this.off;
                }
            }
        }
    }

    private void version() {
        if (this.skip("$Version=")) {
            if (this.buf[this.off] == '\"') {
                ++this.off;
            }
            while (this.off < this.count && this.digit(this.buf[this.off])) {
                this.version *= 10;
                this.version += this.buf[this.off];
                this.version -= 48;
                ++this.off;
            }
            if (this.buf[this.off] == '\"') {
                ++this.off;
            }
        } else {
            this.version = 1;
        }
    }

    private boolean terminal(char ch) {
        return ch == ';';
    }

    private class Token {
        public int len;
        public int off;

        private Token() {
        }

        public String toString() {
            return new String(CookieParser.this.buf, this.off, this.len);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Sequence
    implements Iterator<Cookie> {
        private Sequence() {
        }

        @Override
        public Cookie next() {
            if (!this.hasNext()) {
                return null;
            }
            CookieParser.this.parsed = false;
            return CookieParser.this.getCookie();
        }

        @Override
        public boolean hasNext() {
            if (CookieParser.this.finished) {
                return false;
            }
            if (CookieParser.this.parsed) {
                return true;
            }
            CookieParser.this.parse();
            if (((CookieParser)CookieParser.this).name.len <= 0) {
                CookieParser.this.finished = true;
                return false;
            }
            return true;
        }

        @Override
        public void remove() {
        }
    }
}

