/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.WindowGeometry;

public class MenuScroller {
    private JPopupMenu menu;
    private Component[] menuItems;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private final MenuScrollListener menuListener = new MenuScrollListener();
    private final MouseWheelListener mouseWheelListener = new MouseScrollListener();
    private int topFixedCount;
    private int firstIndex;
    private static final int ARROW_ICON_HEIGHT = 10;

    private int computeScrollCount(int n) {
        int n2 = 15;
        if (this.menu != null) {
            int n3;
            int n4 = WindowGeometry.getMaxDimensionOnScreen((JComponent)this.menu).height - ((JFrame)Main.parent).getInsets().top;
            if (this.topFixedCount > 0) {
                for (n3 = 0; n3 < this.topFixedCount; ++n3) {
                    n4 -= this.menuItems[n3].getPreferredSize().height;
                }
                n4 -= new JSeparator().getPreferredSize().height;
            }
            n4 -= this.menu.getInsets().top;
            n4 -= this.upItem.getPreferredSize().height;
            n4 -= this.downItem.getPreferredSize().height;
            n4 -= this.menu.getInsets().bottom;
            n2 = 0;
            n3 = 0;
            int n5 = n;
            while (n5 < this.menuItems.length && n3 <= n4) {
                n3 += this.menuItems[n5].getPreferredSize().height;
                ++n5;
                ++n2;
            }
            if (n3 > n4) {
                --n2;
            } else {
                n5 = n - 1;
                while (n5 >= 0 && n3 <= n4) {
                    n3 += this.menuItems[n5].getPreferredSize().height;
                    --n5;
                    ++n2;
                }
                if (n3 > n4) {
                    --n2;
                }
            }
        }
        return n2;
    }

    public static MenuScroller setScrollerFor(JMenu jMenu) {
        return new MenuScroller(jMenu);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu) {
        return new MenuScroller(jPopupMenu);
    }

    public static MenuScroller setScrollerFor(JMenu jMenu, int n) {
        return new MenuScroller(jMenu, n);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu, int n) {
        return new MenuScroller(jPopupMenu, n);
    }

    public static MenuScroller setScrollerFor(JMenu jMenu, int n, int n2) {
        return new MenuScroller(jMenu, n, n2);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu, int n, int n2) {
        return new MenuScroller(jPopupMenu, n, n2);
    }

    public MenuScroller(JMenu jMenu) {
        this(jMenu, 150);
    }

    public MenuScroller(JPopupMenu jPopupMenu) {
        this(jPopupMenu, 150);
    }

    public MenuScroller(JMenu jMenu, int n) {
        this(jMenu, n, 0);
    }

    public MenuScroller(JPopupMenu jPopupMenu, int n) {
        this(jPopupMenu, n, 0);
    }

    public MenuScroller(JMenu jMenu, int n, int n2) {
        this(jMenu.getPopupMenu(), n, n2);
    }

    public MenuScroller(JPopupMenu jPopupMenu, int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("topFixedCount cannot be negative");
        }
        this.upItem = new MenuScrollItem(MenuIcon.UP, -1, n);
        this.downItem = new MenuScrollItem(MenuIcon.DOWN, 1, n);
        this.setTopFixedCount(n2);
        this.menu = jPopupMenu;
        jPopupMenu.addPopupMenuListener(this.menuListener);
        jPopupMenu.addMouseWheelListener(this.mouseWheelListener);
    }

    public int getTopFixedCount() {
        return this.topFixedCount;
    }

    public void setTopFixedCount(int n) {
        this.firstIndex = this.firstIndex <= n ? n : (this.firstIndex += n - this.topFixedCount);
        this.topFixedCount = n;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.menuListener);
            this.menu.removeMouseWheelListener(this.mouseWheelListener);
            this.menu.setPreferredSize(null);
            this.menu = null;
        }
    }

    private void refreshMenu() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int n;
            int n2 = 0;
            Component[] componentArray = this.menuItems;
            int n3 = componentArray.length;
            for (n = 0; n < n3; ++n) {
                Component component = componentArray[n];
                n2 += component.getPreferredSize().height;
            }
            int n4 = WindowGeometry.getMaxDimensionOnScreen((JComponent)this.menu).height - ((JFrame)Main.parent).getInsets().top;
            int n5 = n3 = n2 > n4 ? 1 : 0;
            if (n3 != 0) {
                int n6;
                this.firstIndex = Math.max(this.topFixedCount, this.firstIndex);
                n = this.computeScrollCount(this.firstIndex);
                this.firstIndex = Math.min(this.menuItems.length - n, this.firstIndex);
                this.upItem.setEnabled(this.firstIndex > this.topFixedCount);
                this.downItem.setEnabled(this.firstIndex + n < this.menuItems.length);
                this.menu.removeAll();
                for (n6 = 0; n6 < this.topFixedCount; ++n6) {
                    this.menu.add(this.menuItems[n6]);
                }
                if (this.topFixedCount > 0) {
                    this.menu.addSeparator();
                }
                this.menu.add(this.upItem);
                for (n6 = this.firstIndex; n6 < n + this.firstIndex; ++n6) {
                    this.menu.add(this.menuItems[n6]);
                }
                this.menu.add(this.downItem);
                n6 = 0;
                for (Component component : this.menuItems) {
                    n6 = Math.max(n6, component.getPreferredSize().width);
                }
                this.menu.setPreferredSize(new Dimension(n6, this.menu.getPreferredSize().height));
            } else if (!Arrays.equals(this.menu.getComponents(), this.menuItems)) {
                this.menu.removeAll();
                for (Component component : this.menuItems) {
                    this.menu.add(component);
                }
            }
            this.menu.revalidate();
            this.menu.repaint();
        }
    }

    static /* synthetic */ Component[] access$202(MenuScroller menuScroller, Component[] componentArray) {
        menuScroller.menuItems = componentArray;
        return componentArray;
    }

    private class MouseScrollListener
    implements MouseWheelListener {
        private MouseScrollListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            MenuScroller.this.firstIndex = MenuScroller.this.firstIndex + mouseWheelEvent.getWheelRotation();
            MenuScroller.this.refreshMenu();
            if (Main.isDebugEnabled()) {
                Main.debug(this.getClass().getName() + " consuming event " + mouseWheelEvent);
            }
            mouseWheelEvent.consume();
        }
    }

    private static enum MenuIcon implements Icon
    {
        UP(9, 1, 9),
        DOWN(1, 9, 1);

        private static final int[] XPOINTS;
        private final int[] yPoints;

        private MenuIcon(int ... nArray) {
            this.yPoints = nArray;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Dimension dimension = component.getSize();
            Graphics graphics2 = graphics.create(dimension.width / 2 - 5, dimension.height / 2 - 5, 10, 10);
            graphics2.setColor(Color.GRAY);
            graphics2.drawPolygon(XPOINTS, this.yPoints, 3);
            if (component.isEnabled()) {
                graphics2.setColor(Color.BLACK);
                graphics2.fillPolygon(XPOINTS, this.yPoints, 3);
            }
            graphics2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        static {
            XPOINTS = new int[]{1, 5, 9};
        }
    }

    private class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private final MenuScrollTimer timer;

        MenuScrollItem(MenuIcon menuIcon, int n, int n2) {
            this.setIcon(menuIcon);
            this.setDisabledIcon(menuIcon);
            this.timer = new MenuScrollTimer(n, n2);
            this.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.isArmed() && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!this.isArmed() && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    private class MenuScrollTimer
    extends Timer {
        MenuScrollTimer(final int n, int n2) {
            super(n2, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MenuScroller.this.firstIndex = MenuScroller.this.firstIndex + n;
                    MenuScroller.this.refreshMenu();
                }
            });
        }
    }

    private class MenuScrollListener
    implements PopupMenuListener {
        private MenuScrollListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.setMenuItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.restoreMenuItems();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.restoreMenuItems();
        }

        private void setMenuItems() {
            MenuScroller.access$202(MenuScroller.this, MenuScroller.this.menu.getComponents());
            MenuScroller.this.refreshMenu();
        }

        private void restoreMenuItems() {
            MenuScroller.this.menu.removeAll();
            for (Component component : MenuScroller.this.menuItems) {
                MenuScroller.this.menu.add(component);
            }
        }
    }
}

