/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public interface PlatformHook {
    default public void preStartupHook() {
    }

    default public void afterPrefStartupHook() {
    }

    default public void startupHook() {
    }

    public void openUrl(String var1) throws IOException;

    public void initSystemShortcuts();

    default public String makeTooltip(String string, Shortcut shortcut) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>").append(string);
        if (shortcut != null && !shortcut.getKeyText().isEmpty()) {
            stringBuilder.append(" <font size='-2'>(").append(shortcut.getKeyText()).append(")</font>");
        }
        return stringBuilder.append("&nbsp;</html>").toString();
    }

    public String getDefaultStyle();

    default public boolean canFullscreen() {
        return !GraphicsEnvironment.isHeadless() && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
    }

    default public boolean rename(File file, File file2) {
        return file.renameTo(file2);
    }

    public String getOSDescription();

    default public String getOSBuildNumber() {
        return "";
    }

    default public boolean setupHttpsCertificate(String string, KeyStore.TrustedCertificateEntry trustedCertificateEntry) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return false;
    }

    default public X509Certificate getX509Certificate(CertificateAmendment.CertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return null;
    }

    default public String exec(String ... stringArray) throws IOException {
        Process process = Runtime.getRuntime().exec(stringArray);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String string = Utils.strip(bufferedReader.readLine());
            return string;
        }
    }

    public File getDefaultCacheDirectory();

    public File getDefaultPrefDirectory();

    public File getDefaultUserDataDirectory();

    public List<File> getDefaultProj4NadshiftDirectories();

    default public boolean isOpenJDK() {
        String string = System.getProperty("java.home");
        return string != null && string.contains("openjdk");
    }

    default public void askUpdateJava(String string, String string2, String string3, boolean bl) {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Outdated Java version", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Update Java", new Object[0]), I18n.tr("Cancel", new Object[0]));
        if (!extendedDialog.toggleEnable("askUpdateJava" + string).toggleCheckState()) {
            extendedDialog.setButtonIcons("ok", "java", "cancel").setCancelButton(3);
            extendedDialog.setMinimumSize(new Dimension(480, 300));
            extendedDialog.setIcon(2);
            StringBuilder stringBuilder = new StringBuilder(I18n.tr("You are running version {0} of Java.", "<b>" + System.getProperty("java.version") + "</b>")).append("<br><br>");
            if ("Sun Microsystems Inc.".equals(System.getProperty("java.vendor")) && !this.isOpenJDK()) {
                stringBuilder.append("<b>").append(I18n.tr("This version is no longer supported by {0} since {1} and is not recommended for use.", "Oracle", string3)).append("</b><br><br>");
            }
            stringBuilder.append("<b>").append(bl ? I18n.tr("JOSM will soon stop working with this version; we highly recommend you to update to Java {0}.", string) : I18n.tr("You may face critical Java bugs; we highly recommend you to update to Java {0}.", string)).append("</b><br><br>").append(I18n.tr("Would you like to update now ?", new Object[0]));
            extendedDialog.setContent(stringBuilder.toString());
            if (extendedDialog.showDialog().getValue() == 2) {
                try {
                    this.openUrl(string2);
                }
                catch (IOException iOException) {
                    Main.warn(iOException);
                }
            }
        }
    }

    default public void checkExpiredJava() {
        Date date = Utils.getJavaExpirationDate();
        if (date != null && date.before(new Date())) {
            String string = Utils.getJavaLatestVersion();
            this.askUpdateJava(string != null ? string : "latest", Main.pref.get("java.update.url", "https://www.java.com/download"), DateUtils.getDateFormat(2).format(date), false);
        }
    }
}

