/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jruby.anno.MethodDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.CodegenUtils;

public class JavaMethodDescriptor
extends MethodDescriptor<Method> {
    public final Class[] parameters;
    public final Class returnClass;
    public final Class declaringClass;
    public final String signature;
    public final Class[] argumentTypes;

    public JavaMethodDescriptor(Method method) {
        super(method);
        this.declaringClass = method.getDeclaringClass();
        this.parameters = method.getParameterTypes();
        this.returnClass = method.getReturnType();
        int start2 = (this.hasContext ? 1 : 0) + (this.isStatic ? 1 : 0);
        int end2 = this.parameters.length - (this.hasBlock ? 1 : 0);
        this.argumentTypes = new Class[end2 - start2];
        System.arraycopy(this.parameters, start2, this.argumentTypes, 0, end2 - start2);
        this.signature = CodegenUtils.sig(method.getReturnType(), method.getParameterTypes());
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class[] getParameterClasses() {
        return this.parameters;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    @Override
    protected <A extends Annotation> A getAnnotation(Method methodObject, Class<A> annotationType) {
        return methodObject.getAnnotation(annotationType);
    }

    @Override
    protected int getModifiers(Method methodObject) {
        return methodObject.getModifiers();
    }

    @Override
    protected String getDeclaringClassName(Method methodObject) {
        return methodObject.getDeclaringClass().getName();
    }

    @Override
    protected String getSimpleName(Method methodObject) {
        return methodObject.getName();
    }

    @Override
    protected boolean hasContext(Method methodObject) {
        Class<?>[] parameters2 = methodObject.getParameterTypes();
        if (parameters2.length > 0) {
            return parameters2[0] == ThreadContext.class;
        }
        return false;
    }

    @Override
    protected boolean hasBlock(Method methodObject) {
        Class<?>[] parameters2 = methodObject.getParameterTypes();
        if (parameters2.length > 0) {
            return parameters2[parameters2.length - 1] == Block.class;
        }
        return false;
    }

    @Override
    protected int parameterCount(Method methodObject) {
        return methodObject.getParameterTypes().length;
    }

    @Override
    protected String parameterAsString(Method methodObject, int index2) {
        return methodObject.getParameterTypes()[index2].getName();
    }
}

