/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

public class JsConfig {
    public static final List<String> JS_STDLIB = Collections.singletonList(org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForDistDirectory().getJsStdLibJarPath().getAbsolutePath());
    public static final List<String> JS_KOTLIN_TEST = Collections.singletonList(org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForDistDirectory().getJsKotlinTestJarPath().getAbsolutePath());
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    private final Project project;
    private final CompilerConfiguration configuration;
    private final LockBasedStorageManager storageManager;
    private final List<KotlinJavascriptMetadata> metadata;
    @Nullable
    private List<JsModuleDescriptor<ModuleDescriptorImpl>> moduleDescriptors;
    private boolean initialized;

    public JsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration) {
        if (project == null) {
            JsConfig.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            JsConfig.$$$reportNull$$$0(1);
        }
        this.storageManager = new LockBasedStorageManager();
        this.metadata = new SmartList<KotlinJavascriptMetadata>();
        this.moduleDescriptors = null;
        this.initialized = false;
        this.project = project;
        this.configuration = configuration;
    }

    @NotNull
    public CompilerConfiguration getConfiguration() {
        CompilerConfiguration compilerConfiguration = this.configuration;
        if (compilerConfiguration == null) {
            JsConfig.$$$reportNull$$$0(2);
        }
        return compilerConfiguration;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            JsConfig.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    public String getModuleId() {
        String string = this.configuration.getNotNull(CommonConfigurationKeys.MODULE_NAME);
        if (string == null) {
            JsConfig.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public ModuleKind getModuleKind() {
        ModuleKind moduleKind = this.configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        if (moduleKind == null) {
            JsConfig.$$$reportNull$$$0(5);
        }
        return moduleKind;
    }

    @NotNull
    public List<String> getLibraries() {
        List<String> list2 = this.getConfiguration().getList(JSConfigurationKeys.LIBRARIES);
        if (list2 == null) {
            JsConfig.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public boolean checkLibFilesAndReportErrors(@NotNull Reporter report2) {
        if (report2 == null) {
            JsConfig.$$$reportNull$$$0(7);
        }
        return this.checkLibFilesAndReportErrors(report2, null);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull Reporter report2, @Nullable Function1<VirtualFile, Unit> action) {
        List<String> libraries;
        if (report2 == null) {
            JsConfig.$$$reportNull$$$0(8);
        }
        if ((libraries = this.getLibraries()).isEmpty()) {
            return false;
        }
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        HashSet<String> modules = new HashSet<String>();
        boolean skipMetadataVersionCheck = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration).isFlagEnabled(AnalysisFlags.getSkipMetadataVersionCheck());
        for (String path : libraries) {
            File filePath = new File(path);
            if (!filePath.exists()) {
                report2.error("Path '" + path + "' does not exist");
                return true;
            }
            VirtualFile file2 = path.endsWith(".jar") || path.endsWith(".zip") ? jarFileSystem.findFileByPath(path + "!/") : fileSystem.findFileByPath(path);
            if (file2 == null) {
                report2.error("File '" + path + "' does not exist or could not be read");
                return true;
            }
            List<KotlinJavascriptMetadata> metadataList = KotlinJavascriptMetadataUtils.loadMetadata(filePath);
            if (metadataList.isEmpty()) {
                report2.warning("'" + path + "' is not a valid Kotlin Javascript library");
                continue;
            }
            for (KotlinJavascriptMetadata metadata2 : metadataList) {
                if (!metadata2.getVersion().isCompatible() && !skipMetadataVersionCheck) {
                    report2.error("File '" + path + "' was compiled with an incompatible version of Kotlin. The binary version of its metadata is " + metadata2.getVersion() + ", expected version is " + JsMetadataVersion.INSTANCE);
                    return true;
                }
                if (modules.add(metadata2.getModuleName())) continue;
                report2.warning("Module \"" + metadata2.getModuleName() + "\" is defined in more than one file");
            }
            if (action == null) continue;
            action.invoke(file2);
        }
        return false;
    }

    @NotNull
    public List<JsModuleDescriptor<ModuleDescriptorImpl>> getModuleDescriptors() {
        this.init();
        if (this.moduleDescriptors != null) {
            List<JsModuleDescriptor<ModuleDescriptorImpl>> list2 = this.moduleDescriptors;
            if (list2 == null) {
                JsConfig.$$$reportNull$$$0(9);
            }
            return list2;
        }
        this.moduleDescriptors = new SmartList<JsModuleDescriptor<ModuleDescriptorImpl>>();
        ArrayList<ModuleDescriptorImpl> kotlinModuleDescriptors = new ArrayList<ModuleDescriptorImpl>();
        for (KotlinJavascriptMetadata kotlinJavascriptMetadata : this.metadata) {
            JsModuleDescriptor<ModuleDescriptorImpl> descriptor2 = this.createModuleDescriptor(kotlinJavascriptMetadata);
            this.moduleDescriptors.add(descriptor2);
            kotlinModuleDescriptors.add(descriptor2.getData());
        }
        for (JsModuleDescriptor jsModuleDescriptor : this.moduleDescriptors) {
            JsConfig.setDependencies((ModuleDescriptorImpl)jsModuleDescriptor.getData(), kotlinModuleDescriptors);
        }
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list3 = this.moduleDescriptors = Collections.unmodifiableList(this.moduleDescriptors);
        if (list3 == null) {
            JsConfig.$$$reportNull$$$0(10);
        }
        return list3;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        if (!this.getLibraries().isEmpty()) {
            Function1<VirtualFile, Unit> action = new Function1<VirtualFile, Unit>(){

                @Override
                public Unit invoke(VirtualFile file2) {
                    String libraryPath = PathUtil.getLocalPath(file2);
                    assert (libraryPath != null) : "libraryPath for " + file2 + " should not be null";
                    JsConfig.this.metadata.addAll(KotlinJavascriptMetadataUtils.loadMetadata(libraryPath));
                    return Unit.INSTANCE;
                }
            };
            boolean hasErrors = this.checkLibFilesAndReportErrors(new Reporter(){

                @Override
                public void error(@NotNull String message) {
                    if (message == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    throw new IllegalStateException(message);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/js/config/JsConfig$2", "error"));
                }
            }, action);
            assert (!hasErrors) : "hasErrors should be false";
        }
        this.initialized = true;
    }

    private JsModuleDescriptor<ModuleDescriptorImpl> createModuleDescriptor(KotlinJavascriptMetadata metadata2) {
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration);
        assert (metadata2.getVersion().isCompatible() || languageVersionSettings.isFlagEnabled(AnalysisFlags.getSkipMetadataVersionCheck())) : "Expected JS metadata version " + JsMetadataVersion.INSTANCE + ", but actual metadata version is " + metadata2.getVersion();
        ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<" + metadata2.getModuleName() + ">"), this.storageManager, JsPlatform.INSTANCE.getBuiltIns());
        JsModuleDescriptor<PackageFragmentProvider> rawDescriptor = KotlinJavascriptSerializationUtil.readModule(metadata2.getBody(), this.storageManager, moduleDescriptor, new CompilerDeserializationConfiguration(languageVersionSettings));
        PackageFragmentProvider provider = rawDescriptor.getData();
        moduleDescriptor.initialize(provider != null ? provider : PackageFragmentProvider.Empty.INSTANCE);
        return rawDescriptor.copy(moduleDescriptor);
    }

    private static void setDependencies(ModuleDescriptorImpl module, List<ModuleDescriptorImpl> modules) {
        module.setDependencies(CollectionsKt.plus(modules, JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/config/JsConfig";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/config/JsConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKind";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkLibFilesAndReportErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Reporter {
        public void error(@NotNull String message) {
            if (message == null) {
                Reporter.$$$reportNull$$$0(0);
            }
        }

        public void warning(@NotNull String message) {
            if (message == null) {
                Reporter.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "message";
            objectArray2[1] = "org/jetbrains/kotlin/js/config/JsConfig$Reporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warning";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

