from typing import overload, Tuple, Optional, Mapping, Union
import multidict


class URL:
    scheme = ...  # type: str
    raw_user = ...  # type: str
    user = ...  # type: Optional[str]
    raw_password = ...  # type: Optional[str]
    password = ...  # type: Optional[str]
    raw_host = ...  # type: Optional[str]
    host = ...  # type: Optional[str]
    port = ...  # type: Optional[int]
    raw_path = ...  # type: str
    path = ...  # type: str
    raw_query_string = ...  # type: str
    query_string = ...  # type: str
    raw_fragment = ...  # type: str
    fragment = ...  # type: str
    query = ...  # type: multidict.Multidict
    raw_name = ...  # type: str
    name = ...  # type: str
    raw_parts = ...  # type: Tuple[str, ...]
    parts = ...  # type: Tuple[str, ...]
    parent = ...  # type: URL

    @overload
    def __new__(cls, val: str='', *, encoded: bool=False) -> URL: ...
    @overload
    def __new__(cls, val: URL) -> URL: ...

    @classmethod
    def build(cls, *, scheme: str='', user: str='', password: str='', host: str='',
              port: int=None, path: str='', query: Mapping=None, query_string: str='',
              fragment: str='', strict: bool=False) -> URL: ...

    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...

    def __eq__(self, other) -> bool: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...

    def __truediv__(self, str) -> URL: ...

    def is_absolute(self) -> bool: ...
    def is_default_port(self) -> bool: ...

    def origin(self) -> URL: ...
    def relative(self) -> URL: ...

    def with_scheme(self, scheme: str) -> URL: ...
    def with_user(self, user: Optional[str]) -> URL: ...
    def with_password(self, password: Optional[str]) -> URL: ...
    def with_host(self, host: str) -> URL: ...
    def with_port(self, port: Optional[int]) -> URL: ...
    @overload
    def with_query(self, query: Optional[Union[Mapping[str, str], str]]) -> URL: ...
    @overload
    def with_query(self, **kwargs: Mapping[str, str]) -> URL: ...
    def with_fragment(self, fragment: Optional[str]) -> URL: ...
    def with_name(self, name: str) -> URL: ...

    def join(self, url: URL) -> URL: ...

    def human_repr(self) -> str: ...
