/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.form;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XRadioButton;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.GridControl;
import com.sun.star.wizards.document.TimeStampControl;
import com.sun.star.wizards.form.FormDocument;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.ui.UIConsts;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import com.sun.star.wizards.ui.event.XItemListenerAdapter;

public class StyleApplier {
    private final XPropertySet xPageStylePropertySet;
    private final XMultiServiceFactory xMSF;
    private final XRadioButton optNoBorder;
    private final XRadioButton opt3DLook;
    private final XListBox lstStyles;
    private final FormDocument curFormDocument;
    private short iOldLayoutPos;
    private String[] StyleNames;
    private String[] FileNames;
    private static final int SOBACKGROUNDCOLOR = 0;
    private static final int SODBTEXTCOLOR = 1;
    private static final int SOLABELTEXTCOLOR = 2;
    private static final int SOBORDERCOLOR = 5;
    private Short IBorderValue = 1;

    public StyleApplier(WizardDialog CurUnoDialog, FormDocument _curFormDocument) {
        this.curFormDocument = _curFormDocument;
        this.xMSF = this.curFormDocument.xMSF;
        TextStyleHandler oTextStyleHandler = new TextStyleHandler(this.curFormDocument.xTextDocument);
        this.xPageStylePropertySet = oTextStyleHandler.getStyleByName("PageStyles", "Standard");
        short curtabindex = 700;
        Integer IStyleStep = 7;
        String sPageStyles = CurUnoDialog.m_oResource.getResText(2286);
        String sNoBorder = CurUnoDialog.m_oResource.getResText(2229);
        String s3DLook = CurUnoDialog.m_oResource.getResText(2230);
        String sFlat = CurUnoDialog.m_oResource.getResText(2231);
        String sFieldBorder = CurUnoDialog.m_oResource.getResText(2228);
        this.setStyles();
        short[] SelLayoutPos = new short[]{0};
        Object[] objectArray = new Object[7];
        objectArray[0] = UIConsts.INTEGERS[8];
        objectArray[1] = sPageStyles;
        objectArray[2] = 92;
        objectArray[3] = 25;
        objectArray[4] = IStyleStep;
        short s = curtabindex;
        curtabindex = (short)(curtabindex + 1);
        objectArray[5] = s;
        objectArray[6] = 90;
        CurUnoDialog.insertLabel("lblStyles", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray);
        Object[] objectArray2 = new Object[9];
        objectArray2[0] = 143;
        objectArray2[1] = "HID:WIZARDS_HID_DLGFORM_LSTSTYLES";
        objectArray2[2] = 92;
        objectArray2[3] = 35;
        objectArray2[4] = SelLayoutPos;
        objectArray2[5] = IStyleStep;
        objectArray2[6] = this.StyleNames;
        short s2 = curtabindex;
        curtabindex = (short)(curtabindex + 1);
        objectArray2[7] = s2;
        objectArray2[8] = 90;
        this.lstStyles = CurUnoDialog.insertListBox("lstStyles", null, new XItemListenerAdapter(){

            public void itemStateChanged(ItemEvent event) {
                StyleApplier.this.changeLayout();
            }
        }, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.SELECTED_ITEMS, PropertyNames.PROPERTY_STEP, PropertyNames.STRING_ITEM_LIST, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray2);
        Object[] objectArray3 = new Object[9];
        objectArray3[0] = UIConsts.INTEGERS[10];
        objectArray3[1] = "HID:WIZARDS_HID_DLGFORM_CMDNOBORDER";
        objectArray3[2] = sNoBorder;
        objectArray3[3] = 196;
        objectArray3[4] = 39;
        objectArray3[5] = IStyleStep;
        short s3 = curtabindex;
        curtabindex = (short)(curtabindex + 1);
        objectArray3[6] = s3;
        objectArray3[7] = "0";
        objectArray3[8] = 93;
        this.optNoBorder = CurUnoDialog.insertRadioButton("otpNoBorder", new XItemListenerAdapter(){

            public void itemStateChanged(ItemEvent event) {
                StyleApplier.this.changeBorderLayouts();
            }
        }, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray3);
        Object[] objectArray4 = new Object[10];
        objectArray4[0] = UIConsts.INTEGERS[10];
        objectArray4[1] = "HID:WIZARDS_HID_DLGFORM_CMD3DBORDER";
        objectArray4[2] = s3DLook;
        objectArray4[3] = 196;
        objectArray4[4] = 53;
        objectArray4[5] = (short)1;
        objectArray4[6] = IStyleStep;
        short s4 = curtabindex;
        curtabindex = (short)(curtabindex + 1);
        objectArray4[7] = s4;
        objectArray4[8] = "1";
        objectArray4[9] = 93;
        this.opt3DLook = CurUnoDialog.insertRadioButton("otp3DLook", new XItemListenerAdapter(){

            public void itemStateChanged(ItemEvent event) {
                StyleApplier.this.changeBorderLayouts();
            }
        }, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STATE, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray4);
        Object[] objectArray5 = new Object[9];
        objectArray5[0] = UIConsts.INTEGERS[10];
        objectArray5[1] = "HID:WIZARDS_HID_DLGFORM_CMDSIMPLEBORDER";
        objectArray5[2] = sFlat;
        objectArray5[3] = 196;
        objectArray5[4] = 67;
        objectArray5[5] = IStyleStep;
        short s5 = curtabindex;
        curtabindex = (short)(curtabindex + 1);
        objectArray5[6] = s5;
        objectArray5[7] = "2";
        objectArray5[8] = 93;
        CurUnoDialog.insertRadioButton("otpFlat", new XItemListenerAdapter(){

            public void itemStateChanged(ItemEvent event) {
                StyleApplier.this.changeBorderLayouts();
            }
        }, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray5);
        Object[] objectArray6 = new Object[7];
        objectArray6[0] = UIConsts.INTEGERS[8];
        objectArray6[1] = sFieldBorder;
        objectArray6[2] = 192;
        objectArray6[3] = 25;
        objectArray6[4] = IStyleStep;
        short s6 = curtabindex;
        curtabindex = (short)(curtabindex + 1);
        objectArray6[5] = s6;
        objectArray6[6] = 98;
        CurUnoDialog.insertFixedLine("lnFieldBorder", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray6);
    }

    private void setStyles() {
        try {
            Object oRootNode = Configuration.getConfigurationRoot(this.xMSF, "org.openoffice.Office.FormWizard/FormWizard/Styles", false);
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oRootNode);
            String[] StyleNodeNames = xNameAccess.getElementNames();
            this.StyleNames = new String[StyleNodeNames.length];
            this.FileNames = new String[StyleNodeNames.length];
            for (int i = 0; i < StyleNodeNames.length; ++i) {
                Object oStyleNode = xNameAccess.getByName(StyleNodeNames[i]);
                this.StyleNames[i] = (String)Helper.getUnoPropertyValue(oStyleNode, PropertyNames.PROPERTY_NAME);
                this.FileNames[i] = (String)Helper.getUnoPropertyValue(oStyleNode, "CssHref");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private short getStyleIndex() {
        try {
            short[] SelFields = (short[])AnyConverter.toArray((Object)Helper.getUnoPropertyValue(UnoDialog.getModel(this.lstStyles), PropertyNames.SELECTED_ITEMS));
            if (SelFields != null) {
                return SelFields[0];
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(System.err);
        }
        return -1;
    }

    public void applyStyle(boolean _bapplyalways) {
        short iStyle = this.getStyleIndex();
        if ((iStyle != this.iOldLayoutPos || _bapplyalways) && iStyle > -1) {
            this.iOldLayoutPos = iStyle;
            String sFileName = this.FileNames[iStyle];
            int[] iStyles = this.getStyleColors(sFileName);
            this.applyDBControlProperties(iStyles);
        }
    }

    private void changeLayout() {
        short iPos = this.lstStyles.getSelectedItemPos();
        if (iPos != this.iOldLayoutPos) {
            this.iOldLayoutPos = iPos;
            String sFileName = this.FileNames[iPos];
            int[] iStyles = this.getStyleColors(sFileName);
            this.applyDBControlProperties(iStyles);
        }
        this.curFormDocument.unlockallControllers();
    }

    public Short getBorderType() {
        return this.IBorderValue;
    }

    private void changeBorderLayouts() {
        try {
            this.curFormDocument.xTextDocument.lockControllers();
            this.IBorderValue = this.optNoBorder.getState() ? Short.valueOf((short)0) : (this.opt3DLook.getState() ? Short.valueOf((short)1) : Short.valueOf((short)2));
            for (int m = 0; m < this.curFormDocument.oControlForms.size(); ++m) {
                FormDocument.ControlForm curControlForm = this.curFormDocument.oControlForms.get(m);
                if (curControlForm.getArrangemode() == 3) {
                    GridControl oGridControl = curControlForm.getGridControl();
                    oGridControl.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                    continue;
                }
                DatabaseControl[] DBControls = curControlForm.getDatabaseControls();
                for (int n = 0; n < DBControls.length; ++n) {
                    if (DBControls[n].xServiceInfo.supportsService("com.sun.star.drawing.ShapeCollection")) {
                        TimeStampControl oTimeStampControl = (TimeStampControl)DBControls[n];
                        for (int i = 0; i < 2; ++i) {
                            XPropertySet xPropertySet = oTimeStampControl.getControlofGroupShapeByIndex(i);
                            if (xPropertySet == null || !xPropertySet.getPropertySetInfo().hasPropertyByName(PropertyNames.PROPERTY_BORDER)) continue;
                            xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                        }
                        continue;
                    }
                    if (!DBControls[n].xPropertySet.getPropertySetInfo().hasPropertyByName(PropertyNames.PROPERTY_BORDER)) continue;
                    DBControls[n].xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.curFormDocument.unlockallControllers();
    }

    private int getStyleColor(String[] _sDataList, String _sHeader, String _sPropertyDescription) {
        int index = JavaTools.FieldInList(_sDataList, _sHeader);
        if (index > -1) {
            String sPropName = PropertyNames.EMPTY_STRING;
            while (sPropName.indexOf(125) < 0 && index < _sDataList.length - 1) {
                String scurline;
                if ((scurline = _sDataList[index++]).indexOf(_sPropertyDescription) <= 0 || scurline.indexOf(58) <= 0) continue;
                String[] sPropList = JavaTools.ArrayoutofString(scurline, ":");
                String sPropValue = sPropList[1];
                if ((sPropValue = sPropValue.trim()).indexOf(35) <= -1) continue;
                sPropValue = JavaTools.replaceSubString(sPropValue, PropertyNames.EMPTY_STRING, PropertyNames.SEMI_COLON);
                sPropValue = JavaTools.replaceSubString(sPropValue, PropertyNames.EMPTY_STRING, PropertyNames.SPACE);
                return Integer.decode(sPropValue);
            }
        }
        return -1;
    }

    private String getStylePath() {
        String StylesPath = "";
        try {
            StylesPath = FileAccess.getOfficePath(this.xMSF, "Config", "", "");
            StylesPath = FileAccess.combinePaths(this.xMSF, StylesPath, "/wizard/form/styles");
        }
        catch (NoValidPathException noValidPathException) {
            // empty catch block
        }
        return StylesPath;
    }

    private int[] getStyleColors(String _filename) {
        String sFilePath = this.getStylePath() + "/" + _filename;
        int[] oStylePropList = new int[6];
        String[] sData = FileAccess.getDataFromTextFile(this.xMSF, sFilePath);
        if (sData != null) {
            oStylePropList[0] = this.getStyleColor(sData, ".toctitle {", "background-color:");
            oStylePropList[1] = this.getStyleColor(sData, ".doctitle {", "color:");
            oStylePropList[2] = this.getStyleColor(sData, ".toctitle {", "color:");
            oStylePropList[5] = this.getStyleColor(sData, ".tcolor {", "border-color:");
        }
        return oStylePropList;
    }

    private void setDBControlColors(XPropertySet xPropertySet, int[] _iStyleColors) {
        try {
            if (xPropertySet.getPropertySetInfo().hasPropertyByName("TextColor") && _iStyleColors[1] > -1) {
                xPropertySet.setPropertyValue("TextColor", (Object)Integer.decode("#00000"));
            }
            if (xPropertySet.getPropertySetInfo().hasPropertyByName("BackgroundColor")) {
                xPropertySet.setPropertyValue("BackgroundColor", (Object)Integer.decode("#DDDDDD"));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void applyDBControlProperties(int[] _iStyleColors) {
        try {
            for (int m = 0; m < this.curFormDocument.oControlForms.size(); ++m) {
                FormDocument.ControlForm curControlForm = this.curFormDocument.oControlForms.get(m);
                if (curControlForm.getArrangemode() == 3) {
                    if (_iStyleColors[2] > -1) {
                        curControlForm.oGridControl.xPropertySet.setPropertyValue("TextColor", (Object)_iStyleColors[1]);
                    }
                    curControlForm.oGridControl.xPropertySet.setPropertyValue("BackgroundColor", (Object)Integer.decode("#DDDDDD"));
                    continue;
                }
                DatabaseControl[] DBControls = curControlForm.getDatabaseControls();
                for (int n = 0; n < DBControls.length; ++n) {
                    DatabaseControl aDBControl;
                    if (_iStyleColors[1] <= -1 || (aDBControl = DBControls[n]) == null) continue;
                    if (aDBControl.xServiceInfo.supportsService("com.sun.star.drawing.ShapeCollection")) {
                        TimeStampControl oTimeStampControl = (TimeStampControl)aDBControl;
                        for (int i = 0; i < 2; ++i) {
                            XPropertySet xPropertySet = oTimeStampControl.getControlofGroupShapeByIndex(i);
                            if (xPropertySet == null) continue;
                            this.setDBControlColors(xPropertySet, _iStyleColors);
                        }
                        continue;
                    }
                    this.setDBControlColors(aDBControl.xPropertySet, _iStyleColors);
                }
                Control[] LabelControls = curControlForm.getLabelControls();
                for (int n = 0; n < LabelControls.length; ++n) {
                    if (_iStyleColors[2] <= -1) continue;
                    LabelControls[n].xPropertySet.setPropertyValue("TextColor", (Object)_iStyleColors[2]);
                }
            }
            this.xPageStylePropertySet.setPropertyValue("BackColor", (Object)_iStyleColors[0]);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

