/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.customdrawings.gen;

import com.baselet.element.facet.customdrawings.gen.Token;
import java.util.TreeSet;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String INDENT = "    ";
    protected static String EOL = "\n";
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        this(currentTokenVal, expectedTokenSequencesVal, tokenImageVal, null);
    }

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal, String lexicalStateName) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal, lexicalStateName));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage, String lexicalStateName) {
        StringBuilder sb = new StringBuilder();
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        TreeSet<String> sortedOptions = new TreeSet<String>();
        int i = 0;
        while (i < expectedTokenSequences.length) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < expectedTokenSequences[i].length) {
                sortedOptions.add(tokenImage[expectedTokenSequences[i][j]]);
                ++j;
            }
            ++i;
        }
        for (String option : sortedOptions) {
            expected.append(INDENT).append(option).append(EOL);
        }
        sb.append("Encountered unexpected token:");
        Token tok = currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            String tokenText = tok.image;
            String escapedTokenText = ParseException.add_escapes(tokenText);
            if (i2 != 0) {
                sb.append(" ");
            }
            if (tok.kind == 0) {
                sb.append(tokenImage[0]);
                break;
            }
            sb.append(" \"");
            sb.append(escapedTokenText);
            sb.append("\"");
            sb.append(" " + tokenImage[tok.kind]);
            tok = tok.next;
            ++i2;
        }
        sb.append(EOL).append(INDENT).append("at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn);
        sb.append(".").append(EOL);
        if (expectedTokenSequences.length != 0) {
            int numExpectedTokens = expectedTokenSequences.length;
            sb.append(EOL).append("Was expecting" + (numExpectedTokens == 1 ? ":" : " one of:") + EOL + EOL);
            sb.append(expected.toString());
        }
        return sb.toString();
    }

    static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

