/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.predicate.EnvelopeIntersectsVisitor;
import com.vividsolutions.jts.operation.predicate.GeometryContainsPointVisitor;
import com.vividsolutions.jts.operation.predicate.RectangleIntersectsSegmentVisitor;

public class RectangleIntersects {
    private Polygon rectangle;
    private Envelope rectEnv;

    public static boolean intersects(Polygon rectangle, Geometry b) {
        RectangleIntersects rp = new RectangleIntersects(rectangle);
        return rp.intersects(b);
    }

    public RectangleIntersects(Polygon rectangle) {
        this.rectangle = rectangle;
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean intersects(Geometry geom) {
        if (!this.rectEnv.intersects(geom.getEnvelopeInternal())) {
            return false;
        }
        EnvelopeIntersectsVisitor visitor = new EnvelopeIntersectsVisitor(this.rectEnv);
        visitor.applyTo(geom);
        if (visitor.intersects()) {
            return true;
        }
        GeometryContainsPointVisitor ecpVisitor = new GeometryContainsPointVisitor(this.rectangle);
        ecpVisitor.applyTo(geom);
        if (ecpVisitor.containsPoint()) {
            return true;
        }
        RectangleIntersectsSegmentVisitor riVisitor = new RectangleIntersectsSegmentVisitor(this.rectangle);
        riVisitor.applyTo(geom);
        return riVisitor.intersects();
    }
}

