/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Sorter;
import org.apache.lucene.util.automaton.Transition;

public class Automaton
implements Accountable {
    private int nextState;
    private int nextTransition;
    private int curState = -1;
    private int[] states;
    private final BitSet isAccept;
    private int[] transitions;
    private boolean deterministic = true;
    private final Sorter destMinMaxSorter = new InPlaceMergeSorter(){

        private void swapOne(int i, int j) {
            int x = Automaton.this.transitions[i];
            ((Automaton)Automaton.this).transitions[i] = Automaton.this.transitions[j];
            ((Automaton)Automaton.this).transitions[j] = x;
        }

        @Override
        protected void swap(int i, int j) {
            int iStart = 3 * i;
            int jStart = 3 * j;
            this.swapOne(iStart, jStart);
            this.swapOne(iStart + 1, jStart + 1);
            this.swapOne(iStart + 2, jStart + 2);
        }

        @Override
        protected int compare(int i, int j) {
            int jMax;
            int jMin;
            int jDest;
            int iStart = 3 * i;
            int jStart = 3 * j;
            int iDest = Automaton.this.transitions[iStart];
            if (iDest < (jDest = Automaton.this.transitions[jStart])) {
                return -1;
            }
            if (iDest > jDest) {
                return 1;
            }
            int iMin = Automaton.this.transitions[iStart + 1];
            if (iMin < (jMin = Automaton.this.transitions[jStart + 1])) {
                return -1;
            }
            if (iMin > jMin) {
                return 1;
            }
            int iMax = Automaton.this.transitions[iStart + 2];
            if (iMax < (jMax = Automaton.this.transitions[jStart + 2])) {
                return -1;
            }
            if (iMax > jMax) {
                return 1;
            }
            return 0;
        }
    };
    private final Sorter minMaxDestSorter = new InPlaceMergeSorter(){

        private void swapOne(int i, int j) {
            int x = Automaton.this.transitions[i];
            ((Automaton)Automaton.this).transitions[i] = Automaton.this.transitions[j];
            ((Automaton)Automaton.this).transitions[j] = x;
        }

        @Override
        protected void swap(int i, int j) {
            int iStart = 3 * i;
            int jStart = 3 * j;
            this.swapOne(iStart, jStart);
            this.swapOne(iStart + 1, jStart + 1);
            this.swapOne(iStart + 2, jStart + 2);
        }

        @Override
        protected int compare(int i, int j) {
            int jDest;
            int jMax;
            int jMin;
            int iStart = 3 * i;
            int jStart = 3 * j;
            int iMin = Automaton.this.transitions[iStart + 1];
            if (iMin < (jMin = Automaton.this.transitions[jStart + 1])) {
                return -1;
            }
            if (iMin > jMin) {
                return 1;
            }
            int iMax = Automaton.this.transitions[iStart + 2];
            if (iMax < (jMax = Automaton.this.transitions[jStart + 2])) {
                return -1;
            }
            if (iMax > jMax) {
                return 1;
            }
            int iDest = Automaton.this.transitions[iStart];
            if (iDest < (jDest = Automaton.this.transitions[jStart])) {
                return -1;
            }
            if (iDest > jDest) {
                return 1;
            }
            return 0;
        }
    };

    public Automaton() {
        this(2, 2);
    }

    public Automaton(int numStates, int numTransitions) {
        this.states = new int[numStates * 2];
        this.isAccept = new BitSet(numStates);
        this.transitions = new int[numTransitions * 3];
    }

    public int createState() {
        this.growStates();
        int state = this.nextState / 2;
        this.states[this.nextState] = -1;
        this.nextState += 2;
        return state;
    }

    public void setAccept(int state, boolean accept) {
        if (state >= this.getNumStates()) {
            throw new IllegalArgumentException("state=" + state + " is out of bounds (numStates=" + this.getNumStates() + ")");
        }
        if (accept) {
            this.isAccept.set(state);
        } else {
            this.isAccept.clear(state);
        }
    }

    public Transition[][] getSortedTransitions() {
        int numStates = this.getNumStates();
        Transition[][] transitions = new Transition[numStates][];
        for (int s = 0; s < numStates; ++s) {
            int numTransitions = this.getNumTransitions(s);
            transitions[s] = new Transition[numTransitions];
            for (int t = 0; t < numTransitions; ++t) {
                Transition transition = new Transition();
                this.getTransition(s, t, transition);
                transitions[s][t] = transition;
            }
        }
        return transitions;
    }

    BitSet getAcceptStates() {
        return this.isAccept;
    }

    public boolean isAccept(int state) {
        return this.isAccept.get(state);
    }

    public void addTransition(int source, int dest, int label) {
        this.addTransition(source, dest, label, label);
    }

    public void addTransition(int source, int dest, int min, int max) {
        assert (this.nextTransition % 3 == 0);
        if (source >= this.nextState / 2) {
            throw new IllegalArgumentException("source=" + source + " is out of bounds (maxState is " + (this.nextState / 2 - 1) + ")");
        }
        if (dest >= this.nextState / 2) {
            throw new IllegalArgumentException("dest=" + dest + " is out of bounds (max state is " + (this.nextState / 2 - 1) + ")");
        }
        this.growTransitions();
        if (this.curState != source) {
            if (this.curState != -1) {
                this.finishCurrentState();
            }
            this.curState = source;
            if (this.states[2 * this.curState] != -1) {
                throw new IllegalStateException("from state (" + source + ") already had transitions added");
            }
            assert (this.states[2 * this.curState + 1] == 0);
            this.states[2 * this.curState] = this.nextTransition;
        }
        this.transitions[this.nextTransition++] = dest;
        this.transitions[this.nextTransition++] = min;
        this.transitions[this.nextTransition++] = max;
        int n = 2 * this.curState + 1;
        this.states[n] = this.states[n] + 1;
    }

    public void addEpsilon(int source, int dest) {
        Transition t = new Transition();
        int count = this.initTransition(dest, t);
        for (int i = 0; i < count; ++i) {
            this.getNextTransition(t);
            this.addTransition(source, t.dest, t.min, t.max);
        }
        if (this.isAccept(dest)) {
            this.setAccept(source, true);
        }
    }

    public void copy(Automaton other) {
        int stateOffset = this.getNumStates();
        this.states = ArrayUtil.grow(this.states, this.nextState + other.nextState);
        System.arraycopy(other.states, 0, this.states, this.nextState, other.nextState);
        for (int i = 0; i < other.nextState; i += 2) {
            if (this.states[this.nextState + i] == -1) continue;
            int n = this.nextState + i;
            this.states[n] = this.states[n] + this.nextTransition;
        }
        this.nextState += other.nextState;
        int otherNumStates = other.getNumStates();
        BitSet otherAcceptStates = other.getAcceptStates();
        for (int state = 0; state < otherNumStates && (state = otherAcceptStates.nextSetBit(state)) != -1; ++state) {
            this.setAccept(stateOffset + state, true);
        }
        this.transitions = ArrayUtil.grow(this.transitions, this.nextTransition + other.nextTransition);
        System.arraycopy(other.transitions, 0, this.transitions, this.nextTransition, other.nextTransition);
        for (int i = 0; i < other.nextTransition; i += 3) {
            int n = this.nextTransition + i;
            this.transitions[n] = this.transitions[n] + stateOffset;
        }
        this.nextTransition += other.nextTransition;
        if (!other.deterministic) {
            this.deterministic = false;
        }
    }

    private void finishCurrentState() {
        int numTransitions = this.states[2 * this.curState + 1];
        assert (numTransitions > 0);
        int offset = this.states[2 * this.curState];
        int start = offset / 3;
        this.destMinMaxSorter.sort(start, start + numTransitions);
        int upto = 0;
        int min = -1;
        int max = -1;
        int dest = -1;
        for (int i = 0; i < numTransitions; ++i) {
            int tDest = this.transitions[offset + 3 * i];
            int tMin = this.transitions[offset + 3 * i + 1];
            int tMax = this.transitions[offset + 3 * i + 2];
            if (dest == tDest) {
                if (tMin <= max + 1) {
                    if (tMax <= max) continue;
                    max = tMax;
                    continue;
                }
                if (dest != -1) {
                    this.transitions[offset + 3 * upto] = dest;
                    this.transitions[offset + 3 * upto + 1] = min;
                    this.transitions[offset + 3 * upto + 2] = max;
                    ++upto;
                }
                min = tMin;
                max = tMax;
                continue;
            }
            if (dest != -1) {
                this.transitions[offset + 3 * upto] = dest;
                this.transitions[offset + 3 * upto + 1] = min;
                this.transitions[offset + 3 * upto + 2] = max;
                ++upto;
            }
            dest = tDest;
            min = tMin;
            max = tMax;
        }
        if (dest != -1) {
            this.transitions[offset + 3 * upto] = dest;
            this.transitions[offset + 3 * upto + 1] = min;
            this.transitions[offset + 3 * upto + 2] = max;
            ++upto;
        }
        this.nextTransition -= (numTransitions - upto) * 3;
        this.states[2 * this.curState + 1] = upto;
        this.minMaxDestSorter.sort(start, start + upto);
        if (this.deterministic && upto > 1) {
            int lastMax = this.transitions[offset + 2];
            for (int i = 1; i < upto; ++i) {
                min = this.transitions[offset + 3 * i + 1];
                if (min <= lastMax) {
                    this.deterministic = false;
                    break;
                }
                lastMax = this.transitions[offset + 3 * i + 2];
            }
        }
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void finishState() {
        if (this.curState != -1) {
            this.finishCurrentState();
            this.curState = -1;
        }
    }

    public int getNumStates() {
        return this.nextState / 2;
    }

    public int getNumTransitions() {
        return this.nextTransition / 3;
    }

    public int getNumTransitions(int state) {
        assert (state >= 0);
        int count = this.states[2 * state + 1];
        if (count == -1) {
            return 0;
        }
        return count;
    }

    private void growStates() {
        if (this.nextState + 2 > this.states.length) {
            this.states = ArrayUtil.grow(this.states, this.nextState + 2);
        }
    }

    private void growTransitions() {
        if (this.nextTransition + 3 > this.transitions.length) {
            this.transitions = ArrayUtil.grow(this.transitions, this.nextTransition + 3);
        }
    }

    public int initTransition(int state, Transition t) {
        assert (state < this.nextState / 2) : "state=" + state + " nextState=" + this.nextState;
        t.source = state;
        t.transitionUpto = this.states[2 * state];
        return this.getNumTransitions(state);
    }

    public void getNextTransition(Transition t) {
        assert (t.transitionUpto + 3 - this.states[2 * t.source] <= 3 * this.states[2 * t.source + 1]);
        assert (this.transitionSorted(t));
        t.dest = this.transitions[t.transitionUpto++];
        t.min = this.transitions[t.transitionUpto++];
        t.max = this.transitions[t.transitionUpto++];
    }

    private boolean transitionSorted(Transition t) {
        int upto = t.transitionUpto;
        if (upto == this.states[2 * t.source]) {
            return true;
        }
        int nextDest = this.transitions[upto];
        int nextMin = this.transitions[upto + 1];
        int nextMax = this.transitions[upto + 2];
        if (nextMin > t.min) {
            return true;
        }
        if (nextMin < t.min) {
            return false;
        }
        if (nextMax > t.max) {
            return true;
        }
        if (nextMax < t.max) {
            return false;
        }
        if (nextDest > t.dest) {
            return true;
        }
        if (nextDest < t.dest) {
            return false;
        }
        return false;
    }

    public void getTransition(int state, int index, Transition t) {
        int i = this.states[2 * state] + 3 * index;
        t.source = state;
        t.dest = this.transitions[i++];
        t.min = this.transitions[i++];
        t.max = this.transitions[i++];
    }

    static void appendCharString(int c, StringBuilder b) {
        if (c >= 33 && c <= 126 && c != 92 && c != 34) {
            b.appendCodePoint(c);
        } else {
            b.append("\\\\U");
            String s = Integer.toHexString(c);
            if (c < 16) {
                b.append("0000000").append(s);
            } else if (c < 256) {
                b.append("000000").append(s);
            } else if (c < 4096) {
                b.append("00000").append(s);
            } else if (c < 65536) {
                b.append("0000").append(s);
            } else if (c < 0x100000) {
                b.append("000").append(s);
            } else if (c < 0x1000000) {
                b.append("00").append(s);
            } else if (c < 0x10000000) {
                b.append("0").append(s);
            } else {
                b.append(s);
            }
        }
    }

    public String toDot() {
        StringBuilder b = new StringBuilder();
        b.append("digraph Automaton {\n");
        b.append("  rankdir = LR\n");
        b.append("  node [width=0.2, height=0.2, fontsize=8]\n");
        int numStates = this.getNumStates();
        if (numStates > 0) {
            b.append("  initial [shape=plaintext,label=\"\"]\n");
            b.append("  initial -> 0\n");
        }
        Transition t = new Transition();
        for (int state = 0; state < numStates; ++state) {
            b.append("  ");
            b.append(state);
            if (this.isAccept(state)) {
                b.append(" [shape=doublecircle,label=\"" + state + "\"]\n");
            } else {
                b.append(" [shape=circle,label=\"" + state + "\"]\n");
            }
            int numTransitions = this.initTransition(state, t);
            for (int i = 0; i < numTransitions; ++i) {
                this.getNextTransition(t);
                assert (t.max >= t.min);
                b.append("  ");
                b.append(state);
                b.append(" -> ");
                b.append(t.dest);
                b.append(" [label=\"");
                Automaton.appendCharString(t.min, b);
                if (t.max != t.min) {
                    b.append('-');
                    Automaton.appendCharString(t.max, b);
                }
                b.append("\"]\n");
            }
        }
        b.append('}');
        return b.toString();
    }

    int[] getStartPoints() {
        HashSet<Integer> pointset = new HashSet<Integer>();
        pointset.add(0);
        for (int s = 0; s < this.nextState; s += 2) {
            int trans;
            int limit = trans + 3 * this.states[s + 1];
            for (trans = this.states[s]; trans < limit; trans += 3) {
                int min = this.transitions[trans + 1];
                int max = this.transitions[trans + 2];
                pointset.add(min);
                if (max >= 0x10FFFF) continue;
                pointset.add(max + 1);
            }
        }
        int[] points = new int[pointset.size()];
        int n = 0;
        for (Integer m : pointset) {
            points[n++] = m;
        }
        Arrays.sort(points);
        return points;
    }

    public int step(int state, int label) {
        int trans;
        assert (state >= 0);
        assert (label >= 0);
        int limit = trans + 3 * this.states[2 * state + 1];
        for (trans = this.states[2 * state]; trans < limit; trans += 3) {
            int dest = this.transitions[trans];
            int min = this.transitions[trans + 1];
            int max = this.transitions[trans + 2];
            if (min > label || label > max) continue;
            return dest;
        }
        return -1;
    }

    @Override
    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.sizeOf(this.states) + RamUsageEstimator.sizeOf(this.transitions) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (long)(this.isAccept.size() / 8) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + 12L + 1L;
    }

    public static class Builder {
        private int nextState = 0;
        private final BitSet isAccept;
        private int[] transitions;
        private int nextTransition = 0;
        private final Sorter sorter = new InPlaceMergeSorter(){

            private void swapOne(int i, int j) {
                int x = transitions[i];
                ((Builder)this).transitions[i] = transitions[j];
                ((Builder)this).transitions[j] = x;
            }

            @Override
            protected void swap(int i, int j) {
                int iStart = 4 * i;
                int jStart = 4 * j;
                this.swapOne(iStart, jStart);
                this.swapOne(iStart + 1, jStart + 1);
                this.swapOne(iStart + 2, jStart + 2);
                this.swapOne(iStart + 3, jStart + 3);
            }

            @Override
            protected int compare(int i, int j) {
                int jDest;
                int jMax;
                int jMin;
                int jSrc;
                int iStart = 4 * i;
                int jStart = 4 * j;
                int iSrc = transitions[iStart];
                if (iSrc < (jSrc = transitions[jStart])) {
                    return -1;
                }
                if (iSrc > jSrc) {
                    return 1;
                }
                int iMin = transitions[iStart + 2];
                if (iMin < (jMin = transitions[jStart + 2])) {
                    return -1;
                }
                if (iMin > jMin) {
                    return 1;
                }
                int iMax = transitions[iStart + 3];
                if (iMax < (jMax = transitions[jStart + 3])) {
                    return -1;
                }
                if (iMax > jMax) {
                    return 1;
                }
                int iDest = transitions[iStart + 1];
                if (iDest < (jDest = transitions[jStart + 1])) {
                    return -1;
                }
                if (iDest > jDest) {
                    return 1;
                }
                return 0;
            }
        };

        public Builder() {
            this(16, 16);
        }

        public Builder(int numStates, int numTransitions) {
            this.isAccept = new BitSet(numStates);
            this.transitions = new int[numTransitions * 4];
        }

        public void addTransition(int source, int dest, int label) {
            this.addTransition(source, dest, label, label);
        }

        public void addTransition(int source, int dest, int min, int max) {
            if (this.transitions.length < this.nextTransition + 4) {
                this.transitions = ArrayUtil.grow(this.transitions, this.nextTransition + 4);
            }
            this.transitions[this.nextTransition++] = source;
            this.transitions[this.nextTransition++] = dest;
            this.transitions[this.nextTransition++] = min;
            this.transitions[this.nextTransition++] = max;
        }

        public void addEpsilon(int source, int dest) {
            for (int upto = 0; upto < this.nextTransition; upto += 4) {
                if (this.transitions[upto] != dest) continue;
                this.addTransition(source, this.transitions[upto + 1], this.transitions[upto + 2], this.transitions[upto + 3]);
            }
            if (this.isAccept(dest)) {
                this.setAccept(source, true);
            }
        }

        public Automaton finish() {
            int numStates = this.nextState;
            int numTransitions = this.nextTransition / 4;
            Automaton a = new Automaton(numStates, numTransitions);
            for (int state = 0; state < numStates; ++state) {
                a.createState();
                a.setAccept(state, this.isAccept(state));
            }
            this.sorter.sort(0, numTransitions);
            for (int upto = 0; upto < this.nextTransition; upto += 4) {
                a.addTransition(this.transitions[upto], this.transitions[upto + 1], this.transitions[upto + 2], this.transitions[upto + 3]);
            }
            a.finishState();
            return a;
        }

        public int createState() {
            return this.nextState++;
        }

        public void setAccept(int state, boolean accept) {
            if (state >= this.getNumStates()) {
                throw new IllegalArgumentException("state=" + state + " is out of bounds (numStates=" + this.getNumStates() + ")");
            }
            this.isAccept.set(state, accept);
        }

        public boolean isAccept(int state) {
            return this.isAccept.get(state);
        }

        public int getNumStates() {
            return this.nextState;
        }

        public void copy(Automaton other) {
            int offset = this.getNumStates();
            int otherNumStates = other.getNumStates();
            this.copyStates(other);
            Transition t = new Transition();
            for (int s = 0; s < otherNumStates; ++s) {
                int count = other.initTransition(s, t);
                for (int i = 0; i < count; ++i) {
                    other.getNextTransition(t);
                    this.addTransition(offset + s, offset + t.dest, t.min, t.max);
                }
            }
        }

        public void copyStates(Automaton other) {
            int otherNumStates = other.getNumStates();
            for (int s = 0; s < otherNumStates; ++s) {
                int newState = this.createState();
                this.setAccept(newState, other.isAccept(s));
            }
        }
    }
}

