/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public class ShapeAreaValueSource
extends ValueSource {
    private final ValueSource shapeValueSource;
    private final SpatialContext ctx;
    private final boolean geoArea;
    private double multiplier;

    public ShapeAreaValueSource(ValueSource shapeValueSource, SpatialContext ctx, boolean geoArea, double multiplier) {
        this.shapeValueSource = shapeValueSource;
        this.ctx = ctx;
        this.geoArea = geoArea;
        this.multiplier = multiplier;
    }

    public String description() {
        return "area(" + this.shapeValueSource.description() + ",geo=" + this.geoArea + ")";
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.shapeValueSource.createWeight(context, searcher);
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues shapeValues = this.shapeValueSource.getValues(context, readerContext);
        return new DoubleDocValues(this){

            public double doubleVal(int doc) {
                Shape shape = (Shape)shapeValues.objectVal(doc);
                if (shape == null || shape.isEmpty()) {
                    return 0.0;
                }
                return shape.getArea(ShapeAreaValueSource.this.geoArea ? ShapeAreaValueSource.this.ctx : null) * ShapeAreaValueSource.this.multiplier;
            }

            public boolean exists(int doc) {
                return shapeValues.exists(doc);
            }

            public Explanation explain(int doc) {
                Explanation exp = super.explain(doc);
                ArrayList<Explanation> details = new ArrayList<Explanation>(Arrays.asList(exp.getDetails()));
                details.add(shapeValues.explain(doc));
                return Explanation.match((float)exp.getValue(), (String)exp.getDescription(), details);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShapeAreaValueSource that = (ShapeAreaValueSource)((Object)o);
        if (this.geoArea != that.geoArea) {
            return false;
        }
        return this.shapeValueSource.equals((Object)that.shapeValueSource);
    }

    public int hashCode() {
        int result = this.shapeValueSource.hashCode();
        result = 31 * result + (this.geoArea ? 1 : 0);
        return result;
    }
}

