/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.elasticsearch.script.mustache.MultiSearchTemplateResponse;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.script.mustache.TransportSearchTemplateAction;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportMultiSearchTemplateAction
extends HandledTransportAction<MultiSearchTemplateRequest, MultiSearchTemplateResponse> {
    private final TransportSearchTemplateAction searchTemplateAction;

    @Inject
    public TransportMultiSearchTemplateAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, TransportSearchTemplateAction searchTemplateAction) {
        super(settings, "indices:data/read/msearch/template", threadPool, transportService, actionFilters, resolver, MultiSearchTemplateRequest::new);
        this.searchTemplateAction = searchTemplateAction;
    }

    protected void doExecute(MultiSearchTemplateRequest request, final ActionListener<MultiSearchTemplateResponse> listener) {
        final AtomicArray responses = new AtomicArray(request.requests().size());
        final AtomicInteger counter = new AtomicInteger(responses.length());
        for (int i = 0; i < responses.length(); ++i) {
            final int index = i;
            this.searchTemplateAction.execute(request.requests().get(i), (ActionListener)new ActionListener<SearchTemplateResponse>(){

                public void onResponse(SearchTemplateResponse searchTemplateResponse) {
                    responses.set(index, (Object)new MultiSearchTemplateResponse.Item(searchTemplateResponse, null));
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                public void onFailure(Exception e) {
                    responses.set(index, (Object)new MultiSearchTemplateResponse.Item(null, e));
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    MultiSearchTemplateResponse.Item[] items = (MultiSearchTemplateResponse.Item[])responses.toArray((Object[])new MultiSearchTemplateResponse.Item[responses.length()]);
                    listener.onResponse((Object)new MultiSearchTemplateResponse(items));
                }
            });
        }
    }
}

