/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.transfer.TransferCancelledException;

public abstract class AbstractTransporter
implements Transporter {
    private final AtomicBoolean closed = new AtomicBoolean();

    protected AbstractTransporter() {
    }

    @Override
    public void peek(PeekTask task) throws Exception {
        this.failIfClosed(task);
        this.implPeek(task);
    }

    protected abstract void implPeek(PeekTask var1) throws Exception;

    @Override
    public void get(GetTask task) throws Exception {
        this.failIfClosed(task);
        this.implGet(task);
    }

    protected abstract void implGet(GetTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void utilGet(GetTask task, InputStream is, boolean close, long length, boolean resume) throws IOException, TransferCancelledException {
        try {
            task.getListener().transportStarted(resume ? task.getResumeOffset() : 0L, length);
            OutputStream os = task.newOutputStream(resume);
            try {
                AbstractTransporter.copy(os, is, task.getListener());
                os.close();
            }
            finally {
                AbstractTransporter.close(os);
            }
        }
        finally {
            if (close) {
                AbstractTransporter.close(is);
            }
        }
    }

    @Override
    public void put(PutTask task) throws Exception {
        this.failIfClosed(task);
        this.implPut(task);
    }

    protected abstract void implPut(PutTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void utilPut(PutTask task, OutputStream os, boolean close) throws IOException, TransferCancelledException {
        try {
            task.getListener().transportStarted(0L, task.getDataLength());
            InputStream is = task.newInputStream();
            try {
                AbstractTransporter.copy(os, is, task.getListener());
            }
            finally {
                AbstractTransporter.close(is);
            }
            if (close) {
                os.close();
            } else {
                os.flush();
            }
        }
        finally {
            if (close) {
                AbstractTransporter.close(os);
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.implClose();
        }
    }

    protected abstract void implClose();

    private void failIfClosed(TransportTask task) {
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
    }

    private static void copy(OutputStream os, InputStream is, TransportListener listener) throws IOException, TransferCancelledException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        int read = is.read(array);
        while (read >= 0) {
            os.write(array, 0, read);
            buffer.rewind();
            buffer.limit(read);
            listener.transportProgressed(buffer);
            read = is.read(array);
        }
    }

    private static void close(Closeable file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

