/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;

public class ResolutionNode {
    private Artifact artifact;
    private List<ResolutionNode> children;
    private final List<Object> parents;
    private final int depth;
    private final ResolutionNode parent;
    private final List<ArtifactRepository> remoteRepositories;
    private boolean active = true;
    private List<Artifact> trail;

    public ResolutionNode(Artifact artifact, List<ArtifactRepository> remoteRepositories) {
        this.artifact = artifact;
        this.remoteRepositories = remoteRepositories;
        this.depth = 0;
        this.parents = Collections.emptyList();
        this.parent = null;
    }

    public ResolutionNode(Artifact artifact, List<ArtifactRepository> remoteRepositories, ResolutionNode parent) {
        this.artifact = artifact;
        this.remoteRepositories = remoteRepositories;
        this.depth = parent.depth + 1;
        this.parents = new ArrayList<Object>();
        this.parents.addAll(parent.parents);
        this.parents.add(parent.getKey());
        this.parent = parent;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Object getKey() {
        return this.artifact.getDependencyConflictId();
    }

    public void addDependencies(Set<Artifact> artifacts, List<ArtifactRepository> remoteRepositories, ArtifactFilter filter) throws CyclicDependencyException, OverConstrainedVersionException {
        if (artifacts != null && !artifacts.isEmpty()) {
            this.children = new ArrayList<ResolutionNode>(artifacts.size());
            for (Artifact a : artifacts) {
                if (this.parents.contains(a.getDependencyConflictId())) {
                    a.setDependencyTrail(this.getDependencyTrail());
                    throw new CyclicDependencyException("A dependency has introduced a cycle", a);
                }
                this.children.add(new ResolutionNode(a, remoteRepositories, this));
            }
        } else {
            this.children = Collections.emptyList();
        }
        this.trail = null;
    }

    public List<String> getDependencyTrail() throws OverConstrainedVersionException {
        List<Artifact> trial = this.getTrail();
        ArrayList<String> ret = new ArrayList<String>(trial.size());
        for (Artifact artifact : trial) {
            ret.add(artifact.getId());
        }
        return ret;
    }

    private List<Artifact> getTrail() throws OverConstrainedVersionException {
        if (this.trail == null) {
            LinkedList<Artifact> ids = new LinkedList<Artifact>();
            ResolutionNode node = this;
            while (node != null) {
                Artifact artifact = node.getArtifact();
                if (artifact.getVersion() == null) {
                    ArtifactVersion selected = artifact.getSelectedVersion();
                    if (selected != null) {
                        artifact.selectVersion(selected.toString());
                    } else {
                        throw new OverConstrainedVersionException("Unable to get a selected Version for " + artifact.getArtifactId(), artifact);
                    }
                }
                ids.add(0, artifact);
                node = node.parent;
            }
            this.trail = ids;
        }
        return this.trail;
    }

    public boolean isResolved() {
        return this.children != null;
    }

    public boolean isChildOfRootNode() {
        return this.parent != null && this.parent.parent == null;
    }

    public Iterator<ResolutionNode> getChildrenIterator() {
        return this.children.iterator();
    }

    public int getDepth() {
        return this.depth;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public boolean isActive() {
        return this.active;
    }

    public void enable() {
        this.active = true;
        if (this.children != null) {
            for (ResolutionNode node : this.children) {
                node.enable();
            }
        }
    }

    public void disable() {
        this.active = false;
        if (this.children != null) {
            for (ResolutionNode node : this.children) {
                node.disable();
            }
        }
    }

    public boolean filterTrail(ArtifactFilter filter) throws OverConstrainedVersionException {
        boolean success = true;
        if (filter != null) {
            for (Artifact artifact : this.getTrail()) {
                if (filter.include(artifact)) continue;
                success = false;
            }
        }
        return success;
    }

    public String toString() {
        return this.artifact.toString() + " (" + this.depth + "; " + (this.active ? "enabled" : "disabled") + ")";
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }
}

