/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolylineTo16
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPoints;
    private Point[] points;

    PolylineTo16() {
        super(89, 1);
    }

    public PolylineTo16(Rectangle bounds, int numberOfPoints, Point[] points) {
        this();
        this.bounds = bounds;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle r = emf.readRECTL();
        int n = emf.readDWORD();
        PolylineTo16 tag = new PolylineTo16(r, n, emf.readPOINTS(n));
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.numberOfPoints);
        emf.writePOINTS(this.numberOfPoints, this.points);
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #points: " + this.numberOfPoints;
    }
}

