/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.undo;

import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.freehep.swing.undo.DoableEdit;
import org.freehep.swing.undo.LinkableEdit;

public class AnimatedCompoundEdit
extends CompoundEdit
implements DoableEdit,
LinkableEdit {
    private static Logger logger;
    boolean inProgress = true;
    boolean hasBeenDone;
    boolean alive;
    String name;
    LinkableEdit first;
    LinkableEdit last;
    LinkableEdit parent;
    LinkableEdit nextEdit;
    LinkableEdit previousEdit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AnimatedCompoundEdit() {
        this(null);
    }

    public AnimatedCompoundEdit(String name) {
        this(name, false);
    }

    public AnimatedCompoundEdit(boolean done) {
        this(null, done);
    }

    public AnimatedCompoundEdit(String name, boolean done) {
        this.hasBeenDone = done;
        this.alive = true;
        this.name = name;
        logger.fine("begin " + (name != null ? name : "anonymous"));
    }

    public LinkableEdit getParent() {
        return this.parent;
    }

    public void setParent(LinkableEdit parent) {
        if (!$assertionsDisabled && this.parent != null) {
            throw new AssertionError((Object)"parent can only be set once");
        }
        this.parent = parent;
    }

    public LinkableEdit getNextEdit() {
        return this.nextEdit;
    }

    public void setNextEdit(LinkableEdit edit) {
        if (!$assertionsDisabled && this.nextEdit != null && edit != null) {
            throw new AssertionError((Object)"trying to set next while already set");
        }
        this.nextEdit = edit;
    }

    public LinkableEdit getPreviousEdit() {
        return this.previousEdit;
    }

    public void setPreviousEdit(LinkableEdit edit) {
        if (!$assertionsDisabled && this.previousEdit != null && edit != null) {
            throw new AssertionError((Object)"trying to set previous while already set");
        }
        this.previousEdit = edit;
    }

    public void undo() throws CannotUndoException {
        logger.finer("Started on last sub-edit");
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.last.undo();
        this.hasBeenDone = false;
    }

    public void redo() throws CannotRedoException {
        logger.finer("Started on first sub-edit");
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.first.redo();
        this.hasBeenDone = true;
    }

    protected UndoableEdit lastEdit() {
        return this.last;
    }

    public void die() {
        for (LinkableEdit cursor = this.last; cursor != null; cursor = cursor.getPreviousEdit()) {
            cursor.die();
        }
        this.alive = false;
    }

    public boolean addEdit(UndoableEdit edit) {
        if (edit instanceof LinkableEdit) {
            return this.addEdit((LinkableEdit)edit);
        }
        return false;
    }

    public boolean addEdit(LinkableEdit edit) {
        logger.fine(edit.toString());
        if (!this.inProgress) {
            return false;
        }
        if (this.last == null) {
            this.first = edit;
            this.last = edit;
            edit.setParent(this);
            edit.setNextEdit(null);
            edit.setPreviousEdit(null);
            return true;
        }
        if (!this.last.addEdit(edit)) {
            if (edit.replaceEdit(this.last)) {
                this.last = this.last.getPreviousEdit();
                this.last.setNextEdit(null);
            }
            this.last.setNextEdit(edit);
            edit.setParent(this);
            edit.setNextEdit(null);
            edit.setPreviousEdit(this.last);
            this.last = edit;
        }
        return true;
    }

    public void end() {
        logger.fine("end");
        this.inProgress = false;
    }

    public boolean canUndo() {
        return !this.isInProgress() && this.alive && this.hasBeenDone;
    }

    public boolean canRedo() {
        return !this.isInProgress() && this.alive && !this.hasBeenDone;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isSignificant() {
        for (LinkableEdit cursor = this.first; cursor != null; cursor = cursor.getNextEdit()) {
            if (!cursor.isSignificant()) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.last != null) {
            return this.last.getPresentationName();
        }
        return super.getPresentationName();
    }

    public String getUndoPresentationName() {
        if (this.name != null) {
            return "Undo " + this.name;
        }
        if (this.last != null) {
            return this.last.getUndoPresentationName();
        }
        return super.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        if (this.name != null) {
            return "Redo " + this.name;
        }
        if (this.last != null) {
            return this.last.getRedoPresentationName();
        }
        return super.getRedoPresentationName();
    }

    public String toString() {
        return "AnimatedCompoundEdit '" + (this.name != null ? this.name : "anonymous") + "' inProgress: " + this.inProgress;
    }

    static {
        $assertionsDisabled = !AnimatedCompoundEdit.class.desiredAssertionStatus();
        logger = Logger.getLogger(AnimatedCompoundEdit.class.getPackage().getName());
    }
}

