#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tabular
version: 0.2.2.7
id: tabular-0.2.2.7-E3mf3ECVuWqCqIaml40ALC
key: tabular-0.2.2.7-E3mf3ECVuWqCqIaml40ALC
license: BSD3
maintainer: Eric Kow <eric.kow@gmail.com>
homepage: http://hub.darcs.net/kowey/tabular
synopsis: Two-dimensional data tables with rendering functions
description:
    Tabular provides a Haskell representation of two-dimensional
    data tables, the kind that you might find in a spreadsheet or
    or a research report.  It also comes with some default
    rendering functions for turning those tables into ASCII art,
    simple text with an arbitrary delimiter, CSV, HTML or LaTeX.
    .
    Below is an example of the kind of output this library produces.
    The tabular package can group rows and columns, each group
    having one of three separators (no line, single line, double line)
    between its members.
    .
    >     || memtest 1 | memtest 2 ||  time test  | time test 2
    > ====++===========+===========++=============+============
    > A 1 ||       hog |  terrible ||        slow |      slower
    > A 2 ||       pig |   not bad ||        fast |     slowest
    > ----++-----------+-----------++-------------+------------
    > B 1 ||      good |     awful || intolerable |    bearable
    > B 2 ||    better | no chance ||    crawling |     amazing
    > B 3 ||       meh |   well... ||  worst ever |          ok
category: Text
author: Eric Kow
exposed: True
exposed-modules:
    Text.Tabular Text.Tabular.AsciiArt Text.Tabular.SimpleText
    Text.Tabular.Csv Text.Tabular.Html Text.Tabular.Latex
abi: 7771b593ac7244ab6cd522cc55ec754a
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/tabular-0.2.2.7
library-dirs: /usr/lib/ghc-8.0.2/site-local/tabular-0.2.2.7
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/tabular-0.2.2.7
hs-libraries: HStabular-0.2.2.7-E3mf3ECVuWqCqIaml40ALC
depends:
    base-4.9.1.0 csv-0.1.2-IUnXEueXED9ELeVORJac7R
    html-1.0.1.2-8wVtehjIxUEBYXzRus7033
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
haddock-interfaces: /usr/share/doc/haskell-tabular/html/tabular.haddock
haddock-html: /usr/share/doc/haskell-tabular/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
